/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Comment;
import com.atlassian.webdriver.bitbucket.element.DiffCommentForm;
import com.atlassian.webdriver.bitbucket.element.FileContent;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.google.common.base.Supplier;
import java.util.List;
import org.openqa.selenium.By;

public class DiffFileContent
extends FileContent {
    public DiffFileContent(PageElement pageElement) {
        super(pageElement);
    }

    public DiffFileContent(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public DiffFileContent(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, parent, timeoutType);
    }

    public DiffToolbar getToolbar() {
        return this.waitForSourceContainer(new Supplier<DiffToolbar>(){

            public DiffToolbar get() {
                return (DiffToolbar)DiffFileContent.this.elementFinder.find(By.className((String)"file-toolbar"), DiffToolbar.class);
            }
        });
    }

    public DiffCommentForm getNewFileCommentForm() {
        return (DiffCommentForm)this.find(By.cssSelector((String)".file-comments .new-comment-form"), DiffCommentForm.class, TimeoutType.COMPONENT_LOAD);
    }

    public DiffCommentForm openNewFileCommentForm() {
        Poller.waitUntilTrue((TimedQuery)this.find(By.className((String)"fully-loaded")).timed().isPresent());
        this.find(By.className((String)"add-file-comment-trigger")).click();
        return this.getNewFileCommentForm();
    }

    public List<Comment> getFileComments() {
        return this.findAll(By.cssSelector((String)".file-comments .comment"), Comment.class);
    }

    @Override
    protected <T> T waitForSourceContainer(Supplier<T> supplier) {
        this.waitUntilPageLoaded();
        return (T)supplier.get();
    }

    public static class DiffToolbar
    extends LegacyElementPageObject {
        public DiffToolbar(PageElement pageElement) {
            super(pageElement);
        }

        public DiffToolbar(By locator) {
            super(locator);
        }

        public String getBreadCrumbs() {
            return this.find(By.className((String)"breadcrumbs")).getText();
        }

        public String getChangeType() {
            return this.find(By.className((String)"change-type-lozenge")).getText();
        }

        public String getSourceLinkUrl() {
            return this.find(By.className((String)"source-view-link")).getAttribute("href");
        }
    }

    public static class Line
    extends FileContent.Line {
        public Line(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public Line(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public boolean hasFocus() {
            return this.hasClass("last-focus");
        }

        public TimedCondition hasFocusCondition() {
            return this.timed().hasClass("last-focus");
        }

        public boolean commentsHaveFocus() {
            return this.hasClass("last-comment-focus");
        }

        public TimedCondition commentsHaveFocusCondition() {
            return this.timed().hasClass("last-comment-focus");
        }

        @Override
        public boolean isAdd() {
            return this.hasClass("added");
        }

        @Override
        public boolean isDelete() {
            return this.hasClass("removed");
        }

        public int getLine() {
            return Integer.parseInt(this.find(By.className((String)"line-number-marker")).getAttribute("data-line-number"));
        }

        public String getLineType() {
            return this.find(By.className((String)"line-number-marker")).getAttribute("data-line-type");
        }

        public Comment getComment(long id) {
            return (Comment)((Object)this.pageBinder.bind(Comment.class, new Object[]{By.cssSelector((String)(".comment[data-id=\"" + id + "\"]"))}));
        }

        public List<Comment> getComments() {
            return this.findAll(By.className((String)"comment"), Comment.class);
        }

        public PageElement getAddComment() {
            PageElement addComment = this.find(By.className((String)"add-comment-trigger"));
            Poller.waitUntilTrue((TimedQuery)addComment.timed().isVisible());
            return addComment;
        }

        public DiffCommentForm getNewCommentForm() {
            return (DiffCommentForm)this.find(By.className((String)"new-comment-form"), DiffCommentForm.class, TimeoutType.COMPONENT_LOAD);
        }

        public DiffCommentForm openNewCommentForm() {
            this.getAddComment().click();
            return this.getNewCommentForm();
        }

        @Override
        public String getSourceText() {
            String text = this.find(By.tagName((String)"pre")).getText();
            return " ".equals(text) ? "" : text;
        }

        public void scrollIntoView() {
            this.javascript().execute("var $this = jQuery(arguments[0]);var cm = $this.closest('.CodeMirror')[0].CodeMirror;var where = { ch: 0, line: $this.prevAll().length };var margin = 200;cm.scrollIntoView(where, margin);", new Object[0]);
        }
    }
}

