/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.DefaultTimeouts;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.util.DateUtils;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class DeploymentDetailsModal
extends AbstractElementPageObject {
    @Inject
    protected WebDriver driver;
    private final PageElement list;
    private final PageElement spinner = this.find(By.cssSelector((String)".environment-list .spinner"));

    public DeploymentDetailsModal(@Nonnull PageElement container) {
        super(container);
        this.list = container.find(By.className((String)"environment-list"));
        this.waitForLoading();
    }

    public List<DeploymentListRow> getItems() {
        return this.container.findAll(By.cssSelector((String)"li.deployment-row")).stream().map(x$0 -> new DeploymentListRow((PageElement)x$0)).collect(Collectors.toList());
    }

    public void loadNextPage() {
        ElementUtils.scrollContainer(this.list);
        this.waitForLoading();
    }

    private void waitForLoading() {
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isVisible());
        Poller.waitUntilFalse((TimedQuery)this.spinner.timed().isVisible());
    }

    public class DeploymentListRow
    extends AbstractElementPageObject {
        private final PageElement date;
        private final LinkElement environmentLink;

        public DeploymentListRow(PageElement container) {
            super(container);
            this.environmentLink = (LinkElement)container.find(By.tagName((String)"a"), LinkElement.class);
            this.date = container.find(By.tagName((String)"time"));
        }

        public void clickEnvironmentUrl() {
            String originWindow = DeploymentDetailsModal.this.driver.getWindowHandle();
            this.environmentLink.click();
            Poller.waitUntilEquals((Object)2, (TimedQuery)Queries.forSupplier((Timeouts)new DefaultTimeouts(), () -> DeploymentDetailsModal.this.driver.getWindowHandles().size()));
            DeploymentDetailsModal.this.driver.switchTo().window((String)Iterables.getLast((Iterable)DeploymentDetailsModal.this.driver.getWindowHandles()));
            DeploymentDetailsModal.this.driver.close();
            DeploymentDetailsModal.this.driver.switchTo().window(originWindow);
        }

        public Instant getDate() {
            String time = this.date.getAttribute("datetime");
            return DateUtils.parseServerTimestamp(time).toInstant();
        }

        public String getEnvironmentName() {
            return this.environmentLink.getText();
        }

        public String getEnvironmentUrl() {
            return this.environmentLink.getUrl();
        }
    }
}

