/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page.next;

import com.atlassian.bitbucket.pageobjects.element.next.FileContent;
import com.atlassian.bitbucket.pageobjects.element.next.HasRevisionPicker;
import com.atlassian.bitbucket.pageobjects.element.next.RevisionHistoryDialog;
import com.atlassian.bitbucket.pageobjects.page.next.FileLayoutPage;
import org.openqa.selenium.By;

public abstract class FileContentPage<T extends FileContent>
extends FileLayoutPage
implements HasRevisionPicker {
    public FileContentPage(String projectKey, String repoSlug, String path) {
        this(projectKey, repoSlug, path, null);
    }

    public FileContentPage(String projectKey, String repoSlug, String path, FileLayoutPage.RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug, path, revisionSpecifier);
    }

    @Override
    public void doWait() {
        super.doWait();
        ((FileContent)((Object)this.getFileContent())).waitUntilPageLoaded();
    }

    public String getCurrentRevisionAuthor() {
        return this.driver.findElement(By.cssSelector((String)".commit .user-name")).getText();
    }

    public String getCurrentRevisionDate() {
        return this.driver.findElement(By.cssSelector((String)".commit time")).getText();
    }

    public String getCurrentRevisionId() {
        return this.driver.findElement(By.cssSelector((String)".commit .commit-hash a")).getText();
    }

    public String getCurrentRevisionMachineDate() {
        return this.driver.findElement(By.cssSelector((String)".commit time")).getAttribute("datetime");
    }

    public abstract T getFileContent();

    @Override
    public RevisionHistoryDialog getRevisionHistoryDialog() {
        return (RevisionHistoryDialog)((Object)this.pageBinder.bind(RevisionHistoryDialog.class, new Object[0]));
    }

    protected <P> P loadRevision(String revision, Class<P> pageClass) {
        this.getRevisionHistoryDialog().clickItemAndWaitForClose(revision.substring(0, 11));
        return (P)this.pageBinder.bind(pageClass, new Object[]{this.projectKey, this.slug, this.path, new FileLayoutPage.RevisionSpecifier(null, revision)});
    }
}

