/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class BranchTypeConfigurationField {
    @Inject
    private PageElementFinder finder;
    private final String branchTypeId;

    public BranchTypeConfigurationField(@Nonnull String branchTypeId) {
        this.branchTypeId = Objects.requireNonNull(branchTypeId, "branchTypeId");
    }

    public PageElement getPrefixField() {
        return this.getContainer().find(By.cssSelector((String)("input[name='" + this.branchTypeId + "-prefix']")));
    }

    public PageElement getCheckboxField() {
        return this.getContainer().find(By.cssSelector((String)("[data-testid='branch-prefix-" + this.branchTypeId + "--checkbox-label']")));
    }

    public String getPrefix() {
        return this.getPrefixField().getValue();
    }

    public TimedQuery<Boolean> isEnabled() {
        return this.getContainer().find(By.cssSelector((String)("[data-testid='branch-prefix-" + this.branchTypeId + "--hidden-checkbox']"))).timed().hasAttribute("checked", "true");
    }

    public boolean isConfiguredChecked() {
        return this.getContainer().find(By.cssSelector((String)("[data-testid='branch-prefix-" + this.branchTypeId + "--hidden-checkbox']"))).hasAttribute("checked", "true");
    }

    public BranchTypeConfigurationField enable() {
        if (!this.isConfiguredChecked()) {
            this.getCheckboxField().click();
        }
        Poller.waitUntilTrue(this.isEnabled());
        return this;
    }

    public BranchTypeConfigurationField disable() {
        if (this.isConfiguredChecked()) {
            this.getCheckboxField().click();
        }
        Poller.waitUntilFalse(this.isEnabled());
        return this;
    }

    public BranchTypeConfigurationField setPrefix(String prefix) {
        this.getPrefixField().clear().type(new CharSequence[]{prefix});
        return this;
    }

    @WaitUntil
    private void mustExist() {
        Poller.waitUntilTrue((TimedQuery)this.getContainer().timed().isPresent());
    }

    private PageElement getContainer() {
        return this.finder.find(By.className((String)("branch-prefix-" + this.branchTypeId)));
    }

    public String getError() {
        return this.getContainer().find(By.cssSelector((String)("[data-testid='" + this.branchTypeId + "-prefix-error']"))).getText();
    }

    public boolean hasError() {
        return this.getContainer().find(By.cssSelector((String)("[data-testid='" + this.branchTypeId + "-prefix-error']"))).isPresent();
    }
}

