/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.RepositoryTable;
import com.atlassian.webdriver.bitbucket.element.UserRepositoryTable;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import java.util.List;
import java.util.Locale;

public class UserProfileRepositoriesTabPage
extends BitbucketPage {
    @ElementBy(cssSelector=".filterable-repository-table .entity-table", pageElementClass=UserRepositoryTable.class)
    private UserRepositoryTable repositoriesTable;
    @ElementBy(className="paged-table-filter-input")
    private PageElement filterByNameSearchBox;
    @ElementBy(cssSelector=".paged-table-container aui-spinner")
    private PageElement tableSpinner;
    private String username;

    public UserProfileRepositoriesTabPage(String username) {
        this.username = username;
    }

    public String getUrl() {
        return "/users/" + this.username.toLowerCase(Locale.US);
    }

    public TimedQuery<List<RepositoryTable.RepositoryRow>> getRepositories() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.repositoriesTable.getRepositories());
    }

    public String getUsername() {
        return this.username;
    }

    public void enterFilterByNameText(String text) {
        Poller.waitUntilTrue((TimedQuery)this.filterByNameSearchBox.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.filterByNameSearchBox.timed().isEnabled());
        this.filterByNameSearchBox.clear();
        this.filterByNameSearchBox.type(new CharSequence[]{text});
    }

    public boolean isLoading() {
        return this.tableSpinner.isPresent();
    }
}

