/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.EmptyRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.ProjectOverviewPage;
import java.util.List;

public class RepositoryCreatePage
extends BitbucketPage {
    @ElementBy(name="defaultBranchId")
    private PageElement defaultBranchName;
    @ElementBy(name="name")
    private PageElement slugField;
    @ElementBy(name="submit")
    private PageElement submitButton;
    @ElementBy(name="cancel")
    private PageElement cancelButton;
    @ElementBy(className="stash-repository-create-form")
    private PageElement form;
    private final String projectKey;

    public RepositoryCreatePage(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos?create";
    }

    public String getDefaultBranchName() {
        return this.defaultBranchName.getValue();
    }

    public RepositoryCreatePage setDefaultBranchName(String name) {
        this.defaultBranchName.clear();
        this.defaultBranchName.type(new CharSequence[]{name});
        return this;
    }

    public RepositoryCreatePage setName(String name) {
        this.slugField.clear();
        this.slugField.type(new CharSequence[]{name});
        return this;
    }

    public EmptyRepositoryPage submitSuccess() {
        String slug = this.slugField.getValue();
        this.submitButton.click();
        return (EmptyRepositoryPage)this.pageBinder.bind(EmptyRepositoryPage.class, new Object[]{this.projectKey, slug});
    }

    public RepositoryCreatePage submitFail() {
        this.submitButton.click();
        return (RepositoryCreatePage)this.pageBinder.bind(RepositoryCreatePage.class, new Object[]{this.projectKey});
    }

    public ProjectOverviewPage cancel() {
        this.cancelButton.click();
        return (ProjectOverviewPage)this.pageBinder.bind(ProjectOverviewPage.class, new Object[]{this.projectKey});
    }

    public List<String> getFieldsWithErrors() {
        return this.getFieldsWithErrors(this.form);
    }
}

