/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.pageobjects.DelayedBinder;
import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.binder.PageBindingWaitException;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.page.HomePage;
import com.atlassian.pageobjects.page.LoginPage;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.SignUpPage;
import java.net.URISyntaxException;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketLoginPage
extends BitbucketPage
implements LoginPage {
    private static final String LOGIN_URL = "/login";
    private static final Logger log = LoggerFactory.getLogger(BitbucketLoginPage.class);
    private final boolean overrideNextParam;
    @ElementBy(id="captcha-image")
    private PageElement captchaImage;
    @ElementBy(id="captcha-refresh-button")
    private PageElement captchaRefreshButton;
    @ElementBy(id="login-button")
    private PageElement loginButton;
    @ElementBy(id="login-message")
    private PageElement loginMessage;
    @ElementBy(id="password-field")
    private PageElement passwordField;
    @ElementBy(cssSelector="input[name='rememberMe']")
    private PageElement rememberMeCheckbox;
    @ElementBy(cssSelector="[data-testid='remember-me-container']")
    private PageElement rememberMeHiddenPlaceholder;
    @ElementBy(id="username-field")
    private PageElement usernameField;

    public BitbucketLoginPage() {
        this(true);
    }

    public BitbucketLoginPage(boolean overrideNextParam) {
        this.overrideNextParam = overrideNextParam;
    }

    public boolean canSignUp() {
        PageElement signUpLink = this.elementFinder.find(By.xpath((String)"//a[contains(@href, '/signup')]"));
        return (Boolean)signUpLink.timed().isPresent().byDefaultTimeout() != false && (Boolean)signUpLink.timed().isVisible().byDefaultTimeout() != false;
    }

    public void clickCaptchaRefresh() {
        this.captchaRefreshButton.click();
    }

    public SignUpPage clickSignUp() {
        PageElement signUpLink = this.elementFinder.find(By.xpath((String)"//a[contains(@href, '/signup')]"));
        Poller.waitUntilTrue((TimedQuery)signUpLink.timed().isPresent());
        signUpLink.click();
        SignUpPage signUpPage = (SignUpPage)this.pageBinder.bind(SignUpPage.class, new Object[0]);
        Poller.waitUntilTrue((TimedQuery)signUpPage.isHereTimed());
        return signUpPage;
    }

    public String getCaptchImage() {
        return this.captchaImage.getAttribute("src");
    }

    public PageElement getLoginMessage() {
        return this.loginMessage;
    }

    public String getSuccessfulSignUpMessage() {
        PageElement message = this.elementFinder.find(By.cssSelector((String)"[data-testid='additional-success-message'"));
        Poller.waitUntilTrue((TimedQuery)message.timed().isVisible());
        return message.getText();
    }

    public String getUrl() {
        return LOGIN_URL;
    }

    public String getUsername() {
        return (Boolean)this.usernameField.timed().isPresent().byDefaultTimeout() != false ? this.usernameField.getValue() : null;
    }

    public <M extends Page> M login(String username, String password, Class<M> nextPage) {
        return this.login(username, password, false, nextPage, new Object[0]);
    }

    public <M extends Page> M login(String username, String password, Class<M> nextPage, Object ... args) {
        return this.login(username, password, false, nextPage, args);
    }

    public <M extends Page> M login(String username, String password, boolean rememberMe, Class<M> nextPage, Object ... args) {
        Poller.waitUntilTrue((TimedQuery)this.usernameField.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.passwordField.timed().isVisible());
        int i = 1;
        while (true) {
            try {
                log.info("Attempt to login {}", (Object)i);
                this.usernameField.clear();
                this.usernameField.type(new CharSequence[]{username});
            }
            catch (NoSuchElementException e) {
                DelayedBinder delayedBinder = this.pageBinder.delayedBind(nextPage, args);
                if (this.driver.getCurrentUrl().contains(((Page)delayedBinder.get()).getUrl())) {
                    return BitbucketLoginPage.bind(delayedBinder);
                }
                throw e;
            }
            try {
                return this.loginWithUserPreFilled(password, rememberMe, nextPage, args);
            }
            catch (PageBindingWaitException e) {
                log.error("Login attempt {}. PageBindingWaitException: {}", (Object)i, (Object)e.getMessage());
                if (i >= 3) {
                    throw e;
                }
                log.info("------------------------>>>> Attempt {} to login failed <<<<--------------------------", (Object)i, (Object)e);
                ++i;
                continue;
            }
            break;
        }
    }

    public <M extends Page> M loginAsRegularUser(Class<M> nextPage, Object ... args) {
        return this.login(DefaultFuncTestData.getRegularUser(), DefaultFuncTestData.getRegularUserPassword(), nextPage, args);
    }

    public <M extends Page> M loginAsSysAdmin(Class<M> nextPage) {
        return this.login(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), nextPage);
    }

    public <M extends Page> M loginAsSysAdmin(Class<M> nextPage, Object ... args) {
        return this.login(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), nextPage, args);
    }

    public BitbucketLoginPage loginFail(String username, String password, boolean rememberMe) {
        Poller.waitUntilTrue((TimedQuery)this.usernameField.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.passwordField.timed().isVisible());
        this.usernameField.clear();
        this.usernameField.type(new CharSequence[]{username});
        this.passwordField.type(new CharSequence[]{password});
        this.clickRememberMe(rememberMe);
        this.loginButton.click();
        BitbucketLoginPage loginPage = (BitbucketLoginPage)this.pageBinder.bind(BitbucketLoginPage.class, new Object[0]);
        Poller.waitUntilTrue((TimedQuery)loginPage.isHereTimed());
        return loginPage;
    }

    public <M extends Page> M loginWithUserPreFilled(String password, boolean rememberMe, Class<M> nextPage, Object ... args) {
        this.passwordField.type(new CharSequence[]{password});
        this.clickRememberMe(rememberMe);
        String next = this.getNextFromUrl();
        this.loginButton.click();
        Poller.waitUntilFalse((TimedQuery)this.loginButton.timed().isVisible());
        DelayedBinder nextPageBinder = this.pageBinder.delayedBind(nextPage, args);
        if (!((Page)nextPageBinder.get()).getUrl().equalsIgnoreCase(next) && !HomePage.class.isAssignableFrom(nextPage) && this.overrideNextParam) {
            log.info("Navigating to next page: {}", (Object)((Page)nextPageBinder.get()).getUrl());
            return this.visit(nextPage, args);
        }
        return BitbucketLoginPage.bind(nextPageBinder);
    }

    private static <M extends Page> M bind(DelayedBinder<M> delayedBinder) {
        Page page = (Page)delayedBinder.bind();
        BitbucketLoginPage.waitForPage(page);
        return (M)page;
    }

    private static <P extends Page> void waitForPage(P page) {
        if (page instanceof AbstractPage) {
            AbstractPage bitbucketPage = (AbstractPage)page;
            Poller.waitUntilTrue((TimedQuery)bitbucketPage.isHereTimed());
        }
    }

    private void clickRememberMe(boolean rememberMe) {
        if (this.isRememberMeVisibleByCss() && !rememberMe) {
            this.rememberMeCheckbox.click();
        }
    }

    private String getNextFromUrl() {
        try {
            return new URIBuilder(this.driver.getCurrentUrl()).getQueryParams().stream().filter(param -> param.getName().equalsIgnoreCase("next")).map(NameValuePair::getValue).findFirst().orElse(null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isRememberMeVisibleByCss() {
        try {
            this.driver.findElement(By.cssSelector((String)"[data-testid='remember-me-container']"));
        }
        catch (NoSuchElementException e) {
            return true;
        }
        return false;
    }

    private <P extends Page> P visit(Class<P> pageClass, Object ... args) {
        Page page = this.pageBinder.navigateToAndBind(pageClass, args);
        BitbucketLoginPage.waitForPage(page);
        return (P)page;
    }
}

