/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class LicenseCrossgradeWarningDialog
extends Dialog2 {
    @ElementBy(cssSelector="button.show-apps")
    private PageElement showAppsButton;

    public LicenseCrossgradeWarningDialog() {
        super(By.id((String)"apps-crossgrade-warning-dialog"));
    }

    @Override
    By getCancelLinkLocator() {
        return By.cssSelector((String)"a.cancel");
    }

    @Override
    By getMainActionLocator() {
        return By.name((String)"confirmWarning");
    }

    public AppListPage showApps() {
        String currentWindow = this.driver.getWindowHandle();
        this.showAppsButton.click();
        String newWindow = (String)Iterables.getLast((Iterable)this.driver.getWindowHandles());
        Assert.assertThat((String)"Expected a new browser window", (Object)newWindow, (Matcher)Matchers.not((Object)currentWindow));
        this.driver.switchTo().window(newWindow);
        return (AppListPage)this.pageBinder.bind(AppListPage.class, new Object[]{currentWindow});
    }

    public static class AppListPage {
        private final String originWindow;
        @ElementBy(cssSelector="h2")
        private PageElement header;
        @ElementBy(cssSelector="ul#app-list li")
        private Iterable<PageElement> appListItems;
        @Inject
        private WebDriver driver;
        @Inject
        private PageBinder pageBinder;
        @Inject
        private Timeouts timeouts;

        public AppListPage(String originWindow) {
            this.originWindow = originWindow;
        }

        public TimedQuery<String> getHeaderText() {
            return this.header.timed().getText();
        }

        public TimedQuery<List<String>> getAppListItemsTexts() {
            return Queries.forSupplier((Timeouts)this.timeouts, () -> Lists.newArrayList((Iterable)Iterables.transform(this.appListItems, PageElement::getText)), (TimeoutType)TimeoutType.DEFAULT);
        }

        public LicenseCrossgradeWarningDialog closeWindow() {
            this.driver.close();
            this.driver.switchTo().window(this.originWindow);
            return (LicenseCrossgradeWarningDialog)((Object)this.pageBinder.bind(LicenseCrossgradeWarningDialog.class, new Object[0]));
        }
    }
}

