/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page.next;

import com.atlassian.bitbucket.pageobjects.element.CreatePullRequestForm;
import com.atlassian.bitbucket.pageobjects.page.next.CompareAndCreatePage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;

public class PullRequestCreatePage
extends CompareAndCreatePage<PullRequestCreatePage> {
    private final String sourceProjectKey;
    private final String sourceRepoSlug;
    @ElementBy(className="create-pull-request-form")
    private PageElement createPullRequestForm;

    public PullRequestCreatePage(String sourceProjectKey, String sourceRepoSlug) {
        super(sourceProjectKey, sourceRepoSlug);
        this.sourceProjectKey = sourceProjectKey;
        this.sourceRepoSlug = sourceRepoSlug;
    }

    public CreatePullRequestForm clickContinue() {
        this.getContinueButton().click();
        return this.getCreatePullRequestForm();
    }

    public CreatePullRequestForm getCreatePullRequestForm() {
        Poller.waitUntilTrue((TimedQuery)this.isCreatePullRequestFormShowing());
        return (CreatePullRequestForm)this.pageBinder.bind(CreatePullRequestForm.class, new Object[]{this.createPullRequestForm});
    }

    public String getUrl() {
        if (this.sourceProjectKey.startsWith("~")) {
            return String.format("/users/%s/repos/%s/pull-requests?create", this.sourceProjectKey.substring(1), this.sourceRepoSlug);
        }
        return String.format("/projects/%s/repos/%s/pull-requests?create", this.sourceProjectKey, this.sourceRepoSlug);
    }

    public TimedCondition isContinueEnabled() {
        return this.getContinueButton().timed().isEnabled();
    }

    public TimedCondition isCreatePullRequestFormShowing() {
        return this.createPullRequestForm.timed().isPresent();
    }
}

