/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.element.MergeHelpDialog;
import com.atlassian.bitbucket.pageobjects.element.activity.ActivityItem;
import com.atlassian.bitbucket.pageobjects.element.activity.ActivityType;
import com.atlassian.bitbucket.pageobjects.element.activity.CommentedActivityItem;
import com.atlassian.bitbucket.pageobjects.element.codeinsights.CodeInsightsOverviewDialog;
import com.atlassian.bitbucket.pageobjects.element.comments.Comment;
import com.atlassian.bitbucket.pageobjects.element.comments.CommentForm;
import com.atlassian.bitbucket.pageobjects.element.comments.OverviewCommentForm;
import com.atlassian.bitbucket.pageobjects.element.contributing.ContributingGuidelinesDialog;
import com.atlassian.bitbucket.pageobjects.element.tasks.Task;
import com.atlassian.bitbucket.pageobjects.page.PullRequestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.DeploymentDetailsModal;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import org.openqa.selenium.By;

public class PullRequestOverviewPage
extends PullRequestPage<PullRequestOverviewPage> {
    public static int PAGE_SIZE = 25;
    private final long pullRequestId;
    private final String queryParams;
    @ElementBy(className="pull-request-activities-spinner")
    private PageElement activitiesSpinner;
    @ElementBy(className="build-status-icon")
    private PageElement buildStatusIcon;
    @ElementBy(cssSelector="[data-testid='pull-request-builds-summary']")
    private PageElement buildsSummary;
    @ElementBy(cssSelector="[data-testid='code-insights-summary']")
    private PageElement codeInsightsLink;
    @ElementBy(cssSelector=".collapse-button")
    private PageElement collapseButton;
    @ElementBy(cssSelector=".merge-conflict-banner button")
    private PageElement conflictBannerShowDetailsButton;
    @ElementBy(cssSelector="[data-testid='pull-request-contributing-guidelines']")
    private PageElement contributingGuidelinesLink;
    @ElementBy(cssSelector="[data-testid='deployments-summary']")
    private PageElement deploymentSummary;
    @ElementBy(className="deployments-dialog")
    private PageElement deploymentsModal;
    @ElementBy(className="pull-request-new-comment-editor-disabled")
    private PageElement disabledGeneralCommentMessage;
    private long focusedCommentId;
    @ElementBy(className="pull-request-new-comment-editor")
    private PageElement generalCommentEditor;
    @ElementBy(className="comment-editor-wrapper")
    private PageElement generalCommentEditorWrapper;
    @ElementBy(cssSelector=".pull-request-details .pull-request-description")
    private PageElement pullRequestDescription;
    @ElementBy(cssSelector=".pull-request-details-extension")
    private PageElement pullRequestDetailsExtension;
    @ElementBy(cssSelector=".summary-panel .extension-point")
    private PageElement pullRequestSummaryExtension;

    public PullRequestOverviewPage(String projectKey, String slug, long pullRequestId) {
        super(projectKey, slug, pullRequestId);
        this.pullRequestId = pullRequestId;
        this.queryParams = "";
    }

    public PullRequestOverviewPage(String projectKey, String slug, long pullRequestId, long commentId, String action) {
        super(projectKey, slug, pullRequestId);
        this.pullRequestId = pullRequestId;
        this.focusedCommentId = commentId;
        this.queryParams = "?" + UrlUtils.buildQueryParams((Object[])new Object[]{"commentId", commentId, "action", action});
    }

    public Comment addGeneralComment(String message) {
        return ((CommentForm)this.getCommentForm().setText(message)).submitComment();
    }

    public Task addGeneralTask(String message) {
        return ((CommentForm)this.getCommentForm().setText(message)).submitTask();
    }

    public <T extends ActivityItem> TimedQuery<T> getActivityByType(ActivityType activityType) {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            List<ActivityItem> activityItems = this.getActivityItems();
            return activityItems.stream().filter(item -> item.getType() == activityType).findFirst().orElse(null);
        });
    }

    public List<ActivityItem> getActivityItems() {
        this.waitForActivityItems();
        List activityItems = this.elementFinder.findAll(By.cssSelector((String)".pull-request-activities .activity-item"));
        return (List)activityItems.stream().map(activityItem -> {
            ActivityType activityType = ActivityType.fromPageElement(activityItem);
            return (ActivityItem)this.pageBinder.bind(activityType.getClazz(), new Object[]{activityItem, activityType});
        }).collect(MoreCollectors.toImmutableList());
    }

    public BuildStatusIcon getBuildStatusIcon() {
        Poller.waitUntilTrue((TimedQuery)this.buildStatusIcon.timed().isVisible());
        return (BuildStatusIcon)this.pageBinder.bind(BuildStatusIcon.class, new Object[]{this.buildStatusIcon});
    }

    public String getBuildStatusUrl() {
        return this.buildsSummary.getAttribute("href");
    }

    public Comment getCommentAt(int index) {
        CommentedActivityItem commentItem = (CommentedActivityItem)this.getActivityItems().get(index);
        return commentItem.getComment();
    }

    public CommentForm getCommentForm() {
        if (this.generalCommentEditorWrapper.hasClass("collapsed")) {
            this.generalCommentEditorWrapper.click();
        }
        Poller.waitUntilTrue((TimedQuery)this.generalCommentEditor.timed().isVisible());
        return (CommentForm)this.pageBinder.bind(OverviewCommentForm.class, new Object[]{this.generalCommentEditor, this});
    }

    public String getConflictMessage() {
        return this.elementFinder.find(By.cssSelector((String)".pull-request-overview h2")).getText();
    }

    public PageElement getOverviewCommentCSE(String text, int index) {
        CommentedActivityItem commentItem = (CommentedActivityItem)this.getActivityItems().get(index);
        Comment comment = commentItem.getComment();
        return comment.getCommentExtensionPanel().find(By.xpath((String)("//*[.=('" + text + "')]")));
    }

    public PageElement getOverviewCommentActionCSE(String text, int index) {
        CommentedActivityItem commentItem = (CommentedActivityItem)this.getActivityItems().get(index);
        Comment comment = commentItem.getComment();
        return comment.getCommentActionExtension(text);
    }

    public PageElement getOverviewDetailsCSE(String text) {
        Poller.waitUntilTrue((TimedQuery)this.pullRequestDetailsExtension.timed().isVisible());
        return this.pullRequestDetailsExtension.find(By.xpath((String)("//*[.=('" + text + "')]")));
    }

    public PageElement getOverviewSummaryCSE(String text) {
        Poller.waitUntilTrue((TimedQuery)this.pullRequestSummaryExtension.timed().isVisible());
        return this.pullRequestSummaryExtension.find(By.xpath((String)("//*[.=('" + text + "')]")));
    }

    public DeploymentDetailsModal openDeploymentExtraDetails() {
        this.deploymentSummary.click();
        return (DeploymentDetailsModal)this.pageBinder.bind(DeploymentDetailsModal.class, new Object[]{this.deploymentsModal});
    }

    public boolean hasDeploymentSummary() {
        return this.deploymentSummary.isPresent();
    }

    public PageElement getCollapseButton() {
        Poller.waitUntilTrue((TimedQuery)this.collapseButton.timed().isVisible());
        return this.collapseButton;
    }

    public String getDeploymentSummaryText() {
        return this.deploymentSummary.getText();
    }

    public String getDescriptionAsHTML() {
        return ElementUtils.getHtml(this.pullRequestDescription);
    }

    public Comment getFocusedComment() {
        this.waitForActivityItems();
        PageElement focusedCommentElement = this.elementFinder.find(By.xpath((String)("//*[contains(@class, 'comment-with-replies')][.//*[@data-comment-id='" + this.focusedCommentId + "']]")));
        return (Comment)this.pageBinder.bind(Comment.class, new Object[]{focusedCommentElement});
    }

    public Comment getLatestComment() {
        return this.getCommentAt(0);
    }

    @Override
    public long getPullRequestId() {
        return this.pullRequestId;
    }

    @Override
    public String getUrl() {
        return super.getUrl() + "/overview" + this.queryParams;
    }

    public TimedCondition hasBuildStatus() {
        return this.buildStatusIcon.timed().isVisible();
    }

    public boolean hasContributionGuidelines() {
        return this.contributingGuidelinesLink.withTimeout(TimeoutType.AJAX_ACTION).isPresent();
    }

    public TimedCondition isCommentFormDisabled() {
        return this.disabledGeneralCommentMessage.timed().isVisible();
    }

    public PullRequestOverviewPage loadMoreActivityItems() {
        ElementUtils.scrollDocument(this.elementFinder.find(By.className((String)"pull-request-activities")));
        return this;
    }

    public CodeInsightsOverviewDialog openCodeInsightsDialog() {
        this.scrollToTop();
        Poller.waitUntilTrue((TimedQuery)this.codeInsightsLink.timed().isVisible());
        this.codeInsightsLink.click();
        return (CodeInsightsOverviewDialog)this.pageBinder.bind(CodeInsightsOverviewDialog.class, new Object[]{this.elementFinder.find(By.cssSelector((String)"[data-testid='code-insights-modal']")), this});
    }

    public ContributingGuidelinesDialog openContributingGuidelinesDialog() {
        this.scrollToTop();
        Poller.waitUntilTrue((TimedQuery)this.contributingGuidelinesLink.timed().isVisible());
        this.contributingGuidelinesLink.click();
        return (ContributingGuidelinesDialog)this.pageBinder.bind(ContributingGuidelinesDialog.class, new Object[0]);
    }

    public MergeHelpDialog openMergeHelpDialogFromConflictBanner() {
        this.conflictBannerShowDetailsButton.click();
        return (MergeHelpDialog)this.pageBinder.bind(MergeHelpDialog.class, new Object[]{this.elementFinder});
    }

    @WaitUntil
    public void waitUntilPageLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.generalCommentEditorWrapper.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isPresent());
        Poller.waitUntilFalse((TimedQuery)this.activitiesSpinner.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isPresent());
    }

    private void waitForActivityItems() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.id((String)"page")).timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".pull-request-activities > span")).timed().isPresent());
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".pull-request-activities > h3")).timed().isPresent());
    }
}

