/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.bitbucket.hamcrest.IsBlankString;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.AbstractBranchModelSettingsPage;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.openqa.selenium.By;

public class BranchModelProjectSettingsPage
extends AbstractBranchModelSettingsPage<BranchModelProjectSettingsPage, ProjectDevelopmentBranchConfiguration, ProjectProductionBranchConfiguration> {
    private final String projectKey;

    public BranchModelProjectSettingsPage(String projectKey) {
        this.projectKey = projectKey;
    }

    public BranchModelProjectSettingsPage clickSaveWithNewRestriction() {
        this.saveButton.click();
        PageElement confirmRestrictChangesButton = this.elementFinder.find(By.cssSelector((String)"[data-testid='cancel-confirmation-modal-confirm-button']"));
        Poller.waitUntilTrue((TimedQuery)confirmRestrictChangesButton.timed().isVisible());
        confirmRestrictChangesButton.click();
        return this.rebind();
    }

    public ProjectDevelopmentBranchConfiguration getDevelopmentConfiguration() {
        return (ProjectDevelopmentBranchConfiguration)this.pageBinder.bind(ProjectDevelopmentBranchConfiguration.class, new Object[0]);
    }

    public ProjectProductionBranchConfiguration getProductionConfiguration() {
        return (ProjectProductionBranchConfiguration)this.pageBinder.bind(ProjectProductionBranchConfiguration.class, new Object[0]);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getUrl() {
        return "/plugins/servlet/branchmodel/projects/" + this.getProjectKey();
    }

    @Override
    public TimedQuery<Boolean> isRestricted() {
        return this.elementFinder.find(By.cssSelector((String)"span .locked-icon")).timed().isPresent();
    }

    public TimedQuery<Boolean> isRestrictionDropdownEnabled() {
        return this.elementFinder.find(By.id((String)"enforce-settings-dropdown")).timed().isEnabled();
    }

    public TimedQuery<Boolean> isRestrictionProcessing() {
        return this.elementFinder.find(By.cssSelector((String)"[data-testid='restriction-processing']")).timed().isPresent();
    }

    public void setRestriction(boolean isRestricted) {
        this.elementFinder.find(By.id((String)"enforce-settings-dropdown")).click();
        Poller.waitUntil(this.getDropdownOptions(), (Matcher)Matchers.iterableWithSize((int)2));
        List dropDownOptions = (List)this.getDropdownOptions().now();
        if (isRestricted) {
            ((PageElement)dropDownOptions.get(0)).click();
        } else {
            ((PageElement)dropDownOptions.get(1)).click();
        }
    }

    @Override
    BranchModelProjectSettingsPage rebind() {
        BranchModelProjectSettingsPage page = (BranchModelProjectSettingsPage)this.pageBinder.bind(BranchModelProjectSettingsPage.class, new Object[]{this.getProjectKey()});
        Poller.waitUntilTrue((TimedQuery)page.isHereTimed());
        return page;
    }

    private TimedQuery<List<PageElement>> getDropdownOptions() {
        List menuItems = this.elementFinder.findAll(By.cssSelector((String)"button[role=\"menuitem\"]"));
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)menuItems.stream().collect(MoreCollectors.toImmutableList()));
    }

    public static class ProjectDevelopmentBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration<ProjectDevelopmentBranchConfiguration> {
        @Override
        public ProjectDevelopmentBranchConfiguration clearBranchNameField() {
            this.getBranchNameField().clear();
            Poller.waitUntil(this.getBranchName(), (Matcher)IsBlankString.blank());
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameField().timed().getValue();
        }

        @Override
        public ProjectDevelopmentBranchConfiguration typeBranchName(String name) {
            this.clearBranchNameField();
            this.getBranchNameField().type(new CharSequence[]{name});
            Poller.waitUntil(this.getBranchName(), (Matcher)IsEqual.equalTo((Object)name));
            this.finder.find(By.tagName((String)"h2")).click();
            return this;
        }

        private PageElement getBranchNameField() {
            return this.finder.find(By.cssSelector((String)("input[name='branch-model-" + this.type + "']")));
        }
    }

    public static class ProjectProductionBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractProductionBranchConfiguration<ProjectProductionBranchConfiguration> {
        @Override
        public ProjectProductionBranchConfiguration clearBranchNameField() {
            this.getBranchNameField().clear();
            Poller.waitUntil(this.getBranchName(), (Matcher)IsBlankString.blank());
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameField().timed().getValue();
        }

        @Override
        public ProjectProductionBranchConfiguration typeBranchName(String name) {
            this.clearBranchNameField();
            this.getBranchNameField().type(new CharSequence[]{name});
            Poller.waitUntil(this.getBranchName(), (Matcher)IsEqual.equalTo((Object)name));
            this.finder.find(By.tagName((String)"h2")).click();
            return this;
        }

        private PageElement getBranchNameField() {
            return this.finder.find(By.cssSelector((String)("input[name='branch-model-" + this.type + "']")));
        }
    }
}

