/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.AbstractMirrorConfigPage;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorNodesConfigPage;
import org.openqa.selenium.By;

public class MirrorConfigPage
extends AbstractMirrorConfigPage {
    public MirrorConfigPage(String type, String mirrorId) {
        super(type, mirrorId);
    }

    public MirrorConfigPage addProject(String projectName) {
        PageElement projectSelector = this.elementFinder.find(By.cssSelector((String)".project-selector .selector input"));
        PageElement addButton = this.elementFinder.find(By.cssSelector((String)".project-selector .add-button"));
        PageElement autoCompleteResult = this.elementFinder.find(By.xpath((String)("//*[@class='project-selector-option' and ./span[2]/text()='" + projectName + "']")));
        PageElement selectedResult = this.elementFinder.find(By.cssSelector((String)".project-selector")).find(By.xpath((String)(".//*[@class='project-selector-label' and text()='" + projectName + "']")));
        projectSelector.clear().type(new CharSequence[]{projectName});
        Poller.waitUntilTrue((TimedQuery)autoCompleteResult.withTimeout(TimeoutType.AJAX_ACTION).timed().isPresent());
        autoCompleteResult.click();
        Poller.waitUntilTrue((TimedQuery)selectedResult.timed().isVisible());
        addButton.click();
        PageElement project = this.getProjectRow(projectName);
        Poller.waitUntilTrue((TimedQuery)project.timed().isPresent());
        return this;
    }

    @WaitUntil
    public void ensureProjectSelectorIsLoaded() {
        PageElement projectSelector = this.elementFinder.find(By.cssSelector((String)".project-selector .selector input"));
        Poller.waitUntilTrue((TimedQuery)projectSelector.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
    }

    public MirrorAllDialog mirrorAll() {
        this.elementFinder.find(By.cssSelector((String)".mirror-project-config .project-selector .add-all-button")).click();
        return (MirrorAllDialog)this.pageBinder.bind(MirrorAllDialog.class, new Object[]{this});
    }

    public MirrorConfigPage removeProject(String projectName) {
        PageElement projectRow = this.getProjectRow(projectName);
        PageElement removeProject = projectRow.find(By.xpath((String)".//button"));
        removeProject.click();
        Poller.waitUntilFalse((TimedQuery)projectRow.timed().isVisible());
        return this;
    }

    public MirrorNodesConfigPage switchToNodesTab() {
        return this.switchToTab(MirrorNodesConfigPage.class);
    }

    public MirrorConfigPage waitUntilFinishedSyncing() {
        PageElement progressBar = this.elementFinder.find(By.className((String)"mirror-project-sync"));
        Poller.waitUntilFalse((TimedQuery)progressBar.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        return this;
    }

    private PageElement getProjectRow(String projectName) {
        return this.elementFinder.find(By.xpath((String)("//*[@class='synced-projects']//span[text()='" + projectName + "']/ancestor::tr")));
    }

    public class MirrorAllDialog {
        @ElementBy(cssSelector="[data-testid='mirror-all-projects-dialog']")
        private PageElement dialog;

        public MirrorConfigPage cancel() {
            MirrorConfigPage.this.elementFinder.find(By.cssSelector((String)"[data-testid='mirror-all-cancel']")).click();
            Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isPresent());
            return MirrorConfigPage.this;
        }

        @WaitUntil
        public void ensureDialogIsLoaded() {
            Poller.waitUntilTrue((TimedQuery)this.dialog.timed().isVisible());
        }
    }
}

