/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.users;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class LicenseStatusSelector
extends AbstractElementPageObject {
    public static final String ALL = "All";
    public static final String LICENSED = "Licensed";
    public static final String UNLICENSED = "Unlicensed";

    public LicenseStatusSelector(@Nonnull PageElement container) {
        super(container);
    }

    public void selectLicenseStatus(String licenseStatus) {
        this.container.click();
        ((List)Poller.waitUntil(this.getOptions(), (Matcher)CoreMatchers.hasItem((Matcher)PageElementMatchers.withText((String)licenseStatus)))).stream().filter(p -> licenseStatus.equals(p.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("%s not found in the location selector drop-down", licenseStatus))).click();
    }

    private TimedQuery<List<PageElement>> getOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.className((String)"license-status__option")));
    }
}

