/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.git;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import org.openqa.selenium.By;

public class DefaultBranchAdminPage
extends BitbucketPage {
    private static final String URL = "/admin/git/default-branch";
    @ElementBy(cssSelector="[name=\"use-custom-name-radio\"][value=\"use-default\"]")
    private PageElement useDefaultNameRadio;
    @ElementBy(cssSelector="[name=\"use-custom-name-radio\"][value=\"use-custom\"]")
    private PageElement useCustomNameRadio;
    @ElementBy(id="custom-branch-name-field")
    private PageElement customBranchNameField;
    @ElementBy(cssSelector=".form-footer button[type=\"submit\"]")
    private PageElement saveButton;

    public TimedCondition isSaveEnabled() {
        return this.saveButton.timed().isEnabled();
    }

    public DefaultBranchAdminPage clickSave() {
        Poller.waitUntilTrue((TimedQuery)this.isSaveEnabled());
        this.saveButton.click();
        return this;
    }

    public DefaultBranchNameType getDefaultBranchNameType() {
        if (this.useDefaultNameRadio.isSelected()) {
            return DefaultBranchNameType.USE_DEFAULT;
        }
        return DefaultBranchNameType.USE_CUSTOM;
    }

    public DefaultBranchAdminPage setDefaultBranchNameType(DefaultBranchNameType type) {
        switch (type) {
            case USE_DEFAULT: {
                this.useDefaultNameRadio.select();
                break;
            }
            case USE_CUSTOM: {
                this.useCustomNameRadio.select();
            }
        }
        return this;
    }

    public String getCustomBranchName() {
        return this.customBranchNameField.getValue();
    }

    public DefaultBranchAdminPage setCustomBranchName(String customBranchName) {
        this.customBranchNameField.clear().type(new CharSequence[]{customBranchName});
        return this;
    }

    public PageElement getSavedFlag() {
        return this.elementFinder.find(By.cssSelector((String)"[data-testid^=\"default-branch-saved-flag-\"]"));
    }

    public String getUrl() {
        return URL;
    }

    public static enum DefaultBranchNameType {
        USE_DEFAULT,
        USE_CUSTOM;

    }
}

