/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.defaulttasks.dialog;

import com.atlassian.bitbucket.pageobjects.element.CodeMirrorEditor;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.refmatcher.RefMatcherSelector;
import javax.annotation.Nonnull;

public abstract class AbstractDefaultTaskForm
extends AbstractElementPageObject {
    @ElementBy(cssSelector="[data-testid='default-tasks-source-ref-selector']")
    protected PageElement sourceRefSelector;
    @ElementBy(cssSelector="[data-testid='default-tasks-target-ref-selector']")
    protected PageElement targetRefSelector;
    @ElementBy(cssSelector="[data-testid='cancel-button']")
    private PageElement cancelButton;
    @ElementBy(cssSelector="[data-testid='save-button']")
    private PageElement submitButton;
    @ElementBy(cssSelector=".default-tasks-form .editor")
    private PageElement taskDescriptionEditor;

    protected AbstractDefaultTaskForm(@Nonnull PageElement container) {
        super(container);
    }

    public void cancel() {
        this.cancelButton.click();
    }

    public abstract RefMatcherSelector getSourceRefSelector();

    public abstract RefMatcherSelector getTargetRefSelector();

    public void submit() {
        this.submitButton.click();
    }

    public AbstractDefaultTaskForm taskDescription(String task) {
        this.getTaskDescriptionEditor().setText(task);
        return this;
    }

    public CodeMirrorEditor getTaskDescriptionEditor() {
        return (CodeMirrorEditor)this.pageBinder.bind(CodeMirrorEditor.class, new Object[]{this.taskDescriptionEditor});
    }

    public static enum BranchType {
        ANY,
        BRANCH_NAME,
        BRANCH_PATTERN;

    }
}

