/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.DiffSelectionDropdown;
import com.atlassian.webdriver.bitbucket.element.UnifiedDiffFileContent;
import com.atlassian.webdriver.bitbucket.page.FileContentPage;
import com.atlassian.webdriver.bitbucket.page.FileLayoutPage;
import com.atlassian.webdriver.bitbucket.page.FileSideBySideDiffPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.KeyboardShortcuts;
import org.openqa.selenium.By;

public class FileUnifiedDiffPage
extends FileContentPage<UnifiedDiffFileContent> {
    @ElementBy(className="file-content", pageElementClass=UnifiedDiffFileContent.class)
    protected UnifiedDiffFileContent diffContent;
    @ElementBy(id="diff-options-dropdown-trigger")
    protected PageElement dropdown;

    public FileUnifiedDiffPage(String projectKey, String repoSlug, String path) {
        super(projectKey, repoSlug, path);
    }

    public FileUnifiedDiffPage(String projectKey, String repoSlug, String path, FileLayoutPage.RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug, path, revisionSpecifier);
    }

    public FileUnifiedDiffPage(FileSideBySideDiffPage sideBySideDiffPage) {
        super(sideBySideDiffPage.projectKey, sideBySideDiffPage.getSlug(), sideBySideDiffPage.path);
    }

    @Override
    protected String getPathComponent() {
        return "diff";
    }

    @Override
    public UnifiedDiffFileContent getFileContent() {
        return this.diffContent;
    }

    public FileUnifiedDiffPage loadUntilRevision(String revision) {
        return this.loadRevision(revision, FileUnifiedDiffPage.class);
    }

    public FileSideBySideDiffPage switchToSideBySide() {
        ((DiffSelectionDropdown)this.pageBinder.bind(DiffSelectionDropdown.class, new Object[]{this.dropdown})).open().selectSideBySide();
        FileSideBySideDiffPage page = (FileSideBySideDiffPage)this.pageBinder.bind(FileSideBySideDiffPage.class, new Object[]{this.projectKey, this.slug, this.path});
        page.getFileContent().waitUntilFileContentLoaded();
        return page;
    }

    public void moveToNextChange(boolean expectMovement) {
        this.navigateDiff(expectMovement, new Runnable(){

            @Override
            public void run() {
                KeyboardShortcuts.moveToNextSecondary(FileUnifiedDiffPage.this.body);
            }
        });
    }

    public void moveToPreviousChange(boolean expectMovement) {
        this.navigateDiff(expectMovement, new Runnable(){

            @Override
            public void run() {
                KeyboardShortcuts.moveToPreviousSecondary(FileUnifiedDiffPage.this.body);
            }
        });
    }

    private void navigateDiff(boolean expectMovement, Runnable doNavigation) {
        if (expectMovement) {
            ElementUtils.waitUntilUpdated(this.getFileContent().find(By.className((String)"content-view")), doNavigation);
        } else {
            doNavigation.run();
        }
    }
}

