/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.refmatcher;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.refmatcher.RefMatcherEntry;
import com.atlassian.webdriver.bitbucket.element.refmatcher.RefMatcherEntryType;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public abstract class RefMatcherSelector
extends AbstractElementPageObject {
    protected final PageElement branchSelector;
    protected final PageElement selectBranchName;
    private final PageElement branchModelSelector = this.find(By.className((String)"branch-model-selector"));
    private final PageElement patternInput;
    private final PageElement selectAllBranches;
    private final PageElement selectBranchPattern;
    private final PageElement selectBranchingModel;
    private final PageElement selectNone;

    public RefMatcherSelector(@Nonnull PageElement container) {
        super(container);
        this.branchSelector = this.find(By.className((String)"branch-selector"));
        this.patternInput = this.find(By.cssSelector((String)"[data-testid='enter-branch-pattern']"));
        this.selectAllBranches = this.find(By.cssSelector((String)"[data-testid='select-all-branches--radio-input']"));
        this.selectBranchName = this.find(By.cssSelector((String)"[data-testid='select-branch-name--radio-input']"));
        this.selectBranchPattern = this.find(By.cssSelector((String)"[data-testid='select-branch-pattern--radio-input']"));
        this.selectBranchingModel = this.find(By.cssSelector((String)"[data-testid='select-branching-model--radio-input']"));
        this.selectNone = this.find(By.cssSelector((String)"[data-testid='select-none--radio-input']"));
    }

    public RefMatcherEntry getRefMatcher() {
        if (this.selectAllBranches.isPresent() && this.selectAllBranches.isSelected()) {
            return new RefMatcherEntry(RefMatcherEntryType.ANY_BRANCH, "");
        }
        if (this.selectBranchName.isSelected()) {
            String branch = this.branchSelector.find(By.className((String)"filterable-tabs__single-value")).getText();
            return new RefMatcherEntry(RefMatcherEntryType.BRANCH_NAME, branch);
        }
        if (this.selectBranchPattern.isSelected()) {
            String pattern = this.patternInput.getValue();
            return new RefMatcherEntry(RefMatcherEntryType.BRANCH_PATTERN, pattern);
        }
        if (this.selectBranchingModel.isSelected()) {
            String branchModel = this.branchModelSelector.find(By.cssSelector((String)".model-name")).getText();
            return new RefMatcherEntry(RefMatcherEntryType.BRANCH_MODEL, branchModel);
        }
        return new RefMatcherEntry(RefMatcherEntryType.NONE, "");
    }

    public void selectAllBranches() {
        this.selectAllBranches.click();
    }

    public abstract void selectBranch(String var1);

    public void selectBranchPattern(String pattern) {
        this.selectBranchPattern.click();
        this.patternInput.type(new CharSequence[]{pattern});
    }

    public void selectBranchingModel(String branchModel) {
        this.selectBranchingModel.click();
        this.branchModelSelector.click();
        this.branchModelSelector.findAll(By.className((String)"branch-model-selector__option")).stream().map(option -> option.find(By.className((String)"model-name"))).filter(option -> branchModel.equals(option.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)("There is no branch model with model-name " + branchModel))).click();
    }

    public void selectNone() {
        this.selectNone.click();
    }
}

