/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.PullRequestCleanUp;
import com.atlassian.bitbucket.pageobjects.element.PullRequestMergeDiagram;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class PullRequestMergeConfirmDialog
extends AbstractElementPageObject {
    private final PageElement commitMessageBody = this.find(By.cssSelector((String)"[data-testid='commit-message-body']"));
    private final PageElement commitMessageTitle = this.find(By.id((String)"commit-message-title"));
    private final PageElement errorMessage = this.find(By.className((String)"merge-dialog-error-section"));
    private final PageElement mergeDiagram = this.find(By.className((String)"merge-diagram"));
    private final PageElement mergeDialogMergeButton = this.find(By.className((String)"action-button"));
    private final PageElement mergeStrategyDropDown = this.find(By.cssSelector((String)"[data-testid=merge-strategy-dropdown--trigger]"));
    private final PageElement vetoesWarningMessage = this.find(By.cssSelector((String)"[data-testid='auto-merge-vetoes-warning']"));
    @Inject
    private PageElementFinder elementFinder;

    public PullRequestMergeConfirmDialog(@Nonnull PageElementFinder elementFinder) {
        super(elementFinder.find(By.cssSelector((String)"[data-testid='pull-request-merge-modal']")));
    }

    public void confirmMerge() {
        this.mergeDialogMergeButton.click();
        if (this.errorMessage.withTimeout(TimeoutType.AJAX_ACTION).isPresent()) {
            return;
        }
        PageElement pullRequestMergeConfirmDialog = this.elementFinder.find(By.cssSelector((String)"[data-testid='pull-request-merge-modal']"));
        Poller.waitUntilFalse((TimedQuery)pullRequestMergeConfirmDialog.timed().isPresent());
    }

    public PullRequestCleanUp getCleanUp() {
        return (PullRequestCleanUp)this.pageBinder.bind(PullRequestCleanUp.class, new Object[]{this.find(By.className((String)"pull-request-clean-up"))});
    }

    public TimedQuery<String> getCommitMessageBody() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ((PageElement)this.commitMessageBody).getValue());
    }

    public TimedQuery<String> getCommitMessageTitle() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ((PageElement)this.commitMessageTitle).getValue());
    }

    public PageElement getError() {
        return this.errorMessage;
    }

    public PageElement getMergeButton() {
        return this.mergeDialogMergeButton;
    }

    public PageElement getMergeButtonRecentIcon() {
        return this.mergeDialogMergeButton.find(By.cssSelector((String)"[data-testid='recent-icon']"));
    }

    public PullRequestMergeDiagram getMergeDiagram() {
        return (PullRequestMergeDiagram)this.pageBinder.bind(PullRequestMergeDiagram.class, new Object[]{this.mergeDiagram});
    }

    public PageElement getMergeStrategyDropDown() {
        return this.mergeStrategyDropDown;
    }

    public List<PageElement> getMergeStrategyList() {
        PageElement mergeStrategies = this.elementFinder.find(By.cssSelector((String)"[data-testid=merge-strategy-dropdown--content]"));
        return (List)mergeStrategies.findAll(By.cssSelector((String)"[role=menuitem]")).stream().collect(MoreCollectors.toImmutableList());
    }

    public PageElement getVetoesWarningMessage() {
        return this.vetoesWarningMessage;
    }

    public void setCommitMessageTitle(String msg) {
        this.commitMessageTitle.type(new CharSequence[]{msg});
    }
}

