/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.util;

import com.atlassian.pageobjects.elements.query.TimedQuery;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class TimedUtils {
    @Nonnull
    public static <S> MappableQuery<S> toMappable(@Nonnull TimedQuery<S> query) {
        return new DelegatingMappableQuery(Objects.requireNonNull(query, "query"), arg -> arg);
    }

    private static final class DelegatingMappableQuery<X, T>
    implements MappableQuery<X> {
        private final Function<T, X> mapper;
        private final TimedQuery<T> query;

        private DelegatingMappableQuery(TimedQuery<T> query, Function<T, X> mapper) {
            this.query = query;
            this.mapper = mapper;
        }

        public X by(long timeoutInMillis) {
            return this.mapper.apply(this.query.by(timeoutInMillis));
        }

        public X by(long timeout, TimeUnit unit) {
            return this.mapper.apply(this.query.by(timeout, unit));
        }

        public X byDefaultTimeout() {
            return this.mapper.apply(this.query.byDefaultTimeout());
        }

        public X call() throws Exception {
            return this.mapper.apply(this.query.call());
        }

        public long defaultTimeout() {
            return this.query.defaultTimeout();
        }

        public long interval() {
            return this.query.interval();
        }

        @Override
        @Nonnull
        public <S> MappableQuery<S> map(@Nonnull Function<X, S> mapper) {
            return new DelegatingMappableQuery<S, X>(this, Objects.requireNonNull(mapper, "mapper"));
        }

        public X now() {
            return this.mapper.apply(this.query.now());
        }
    }

    public static interface MappableQuery<X>
    extends TimedQuery<X> {
        @Nonnull
        public <S> MappableQuery<S> map(@Nonnull Function<X, S> var1);
    }
}

