/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.BranchTypeConfigurationField;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import javax.inject.Inject;
import org.openqa.selenium.By;

public abstract class AbstractBranchModelSettingsPage<T extends AbstractBranchModelSettingsPage<T, U, V>, U extends AbstractDevelopmentBranchConfiguration<U>, V extends AbstractProductionBranchConfiguration<V>>
extends BaseSidebarPage {
    public static final String BUGFIX_TYPE_ID = "BUGFIX";
    public static final String FEATURE_TYPE_ID = "FEATURE";
    public static final String HOTFIX_TYPE_ID = "HOTFIX";
    public static final String RELEASE_TYPE_ID = "RELEASE";
    @ElementBy(id="branch-model-settings-form-submit")
    protected PageElement saveButton;
    @ElementBy(id="branch-model-automerge-enabled")
    protected AuiCheckbox autoMerge;
    @ElementBy(id="branch-model-automerge-mergecheck-enabled")
    protected AuiCheckbox autoMergeCheck;
    @ElementBy(id="branch-delete-source-enabled")
    protected AuiCheckbox deleteSourceEnabled;
    @ElementBy(id="branch-delete-source-disabled")
    protected AuiCheckbox deleteSourceDisabled;
    @ElementBy(className="aui-message-success")
    protected PageElement updateSuccessfulMessage;
    @ElementBy(id="branch-model-cancel")
    protected PageElement cancelLink;

    public T cancelChanges() {
        this.cancelLink.click();
        return this.self();
    }

    public T enableAutoMerge() {
        Poller.waitUntilTrue(this.isAutoMergeFieldEnabled());
        this.autoMerge.check();
        Poller.waitUntilTrue(this.isAutoMergeEnabled());
        return this.self();
    }

    public AbstractBranchModelSettingsPage enableAutoMergeCheck() {
        Poller.waitUntilTrue(this.isAutoMergeCheckFieldEnabled());
        this.autoMergeCheck.check();
        Poller.waitUntilTrue(this.isAutoMergeCheckEnabled());
        return this.self();
    }

    public AbstractBranchModelSettingsPage enableDeleteSource() {
        this.deleteSourceEnabled.check();
        return this.self();
    }

    public AbstractBranchModelSettingsPage disabledDeleteSource() {
        this.deleteSourceDisabled.check();
        return this.self();
    }

    public BranchTypeConfigurationField getBranchTypeConfiguration(String branchTypeId) {
        return (BranchTypeConfigurationField)this.pageBinder.bind(BranchTypeConfigurationField.class, new Object[]{branchTypeId});
    }

    public abstract AbstractDevelopmentBranchConfiguration<U> getDevelopmentConfiguration();

    public abstract AbstractProductionBranchConfiguration<V> getProductionConfiguration();

    public TimedQuery<Boolean> isAutoMergeChecked() {
        return this.autoMerge.timed().isSelected();
    }

    public TimedQuery<Boolean> isAutoMergeEnabled() {
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.isAutoMergeFieldEnabled(), this.autoMerge.timed().isSelected()});
    }

    public TimedQuery<Boolean> isAutoMergeCheckEnabled() {
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.isAutoMergeCheckFieldEnabled(), this.autoMergeCheck.timed().isSelected()});
    }

    public TimedQuery<Boolean> isAutoMergeFieldEnabled() {
        return this.autoMerge.timed().isEnabled();
    }

    public TimedQuery<Boolean> isAutoMergeCheckFieldEnabled() {
        return this.autoMergeCheck.timed().isEnabled();
    }

    public boolean isDeleteSourceChecked() {
        return this.deleteSourceEnabled.isSelected();
    }

    public boolean isDeleteSourceFieldEnabled() {
        return this.deleteSourceEnabled.isEnabled();
    }

    public boolean isDeleteSourceUnchecked() {
        return this.deleteSourceDisabled.isSelected();
    }

    public boolean isSuccessfulUpdate() {
        return this.updateSuccessfulMessage.isPresent();
    }

    public T clickSave() {
        this.saveButton.click();
        return this.rebind();
    }

    protected T self() {
        return (T)this;
    }

    abstract T rebind();

    public static abstract class AbstractProductionBranchConfiguration<T extends AbstractProductionBranchConfiguration<T>>
    extends AbstractBranchConfiguration<T> {
        public AbstractProductionBranchConfiguration() {
            super("production");
        }

        private AuiCheckbox getNoProductionBranch() {
            return ElementUtils.findCheckbox(this.finder, By.id((String)"branch-model-production-type-none"));
        }

        public boolean isNoProductionBranch() {
            return this.getNoProductionBranch().hasAttribute("checked", "true");
        }

        public void selectNoProductionBranch() {
            this.getNoProductionBranch().select();
        }
    }

    public static abstract class AbstractDevelopmentBranchConfiguration<T extends AbstractDevelopmentBranchConfiguration<T>>
    extends AbstractBranchConfiguration<T> {
        public AbstractDevelopmentBranchConfiguration() {
            super("development");
        }
    }

    public static abstract class AbstractBranchConfiguration<T extends AbstractBranchConfiguration<T>> {
        protected final String type;
        @Inject
        protected PageBinder pageBinder;
        @Inject
        protected PageElementFinder finder;

        public AbstractBranchConfiguration(String type) {
            this.type = type;
        }

        public abstract T clearBranchNameField();

        public abstract TimedQuery<String> getBranchName();

        public PageElement getError() {
            return this.finder.find(By.cssSelector((String)("#branch-model-" + this.type + "-type + fieldset > .error")));
        }

        protected PageElement getUseBranchName() {
            return ElementUtils.findCheckbox(this.finder, By.id((String)("branch-model-" + this.type + "-type-branch-name")));
        }

        protected AuiCheckbox getUseDefaultBranch() {
            return ElementUtils.findCheckbox(this.finder, By.id((String)("branch-model-" + this.type + "-type-default")));
        }

        public boolean isUseDefaultBranch() {
            return this.getUseDefaultBranch().hasAttribute("checked", "true");
        }

        public T selectUseBranchName() {
            Poller.waitUntilTrue((TimedQuery)this.getUseBranchName().select().timed().isSelected());
            return this.self();
        }

        public T selectUseDefaultBranch() {
            Poller.waitUntilTrue((TimedQuery)this.getUseDefaultBranch().select().timed().isSelected());
            return this.self();
        }

        public abstract T typeBranchName(String var1);

        protected T self() {
            return (T)this;
        }
    }
}

