/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement;

import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.CheckboxElement;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.ActivityFilter;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.BulkDeleteConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.BulkMoveConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.DeleteConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.LocationSelector;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.MoveConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.RepositoryListItem;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.openqa.selenium.By;

public class RepositoryManagementPage
extends BitbucketPage {
    public static final String SELECT_ALL_ATTR_CHECKED = "aria-checked";
    public static final String SELECT_ALL_STATE_CHECKED = "true";
    public static final String SELECT_ALL_STATE_MIXED = "mixed";
    public static final String SELECT_ALL_STATE_UNCHECKED = "false";
    @ElementBy(cssSelector="[data-testid='bulk-action-modal']")
    private PageElement bulkActionModal;
    @ElementBy(cssSelector="button[data-testid='bulk-delete']")
    private PageElement bulkDeleteButton;
    @ElementBy(cssSelector="button[data-testid='bulk-move']")
    private PageElement bulkMoveButton;
    @ElementBy(cssSelector="[data-testid='delete-repository-modal']")
    private PageElement deleteModal;
    @ElementBy(cssSelector="[data-testid='move-repository-modal']")
    private PageElement moveModal;
    @ElementBy(id="search-filter")
    private PageElement searchBox;
    @ElementBy(cssSelector="[data-testid='select-all-repositories--hidden-checkbox']")
    private CheckboxElement selectAllCheckbox;
    @ElementBy(className="select-all-repositories")
    private PageElement selectAllContainer;
    @ElementBy(cssSelector="[data-testid='bulk-select-count']")
    private PageElement selectionCount;
    @ElementBy(className="repository-management-table")
    private PageElement table;
    @ElementBy(className="location-filter-select")
    private PageElement locationFilter;
    @ElementBy(className="repository-management-date-filter")
    private PageElement activityFilter;

    public void clickBulkDelete() {
        this.bulkDeleteButton.click();
    }

    public void clickBulkMove() {
        this.bulkMoveButton.click();
    }

    public void clickSelectAll() {
        this.selectAllContainer.click();
    }

    public void enterTextInSearchBox(String text) {
        this.searchBox.type(new CharSequence[]{text});
    }

    public BulkDeleteConfirmationDialog getBulkDeleteConfirmationDialog() {
        Poller.waitUntilTrue((TimedQuery)this.bulkActionModal.timed().isVisible());
        return (BulkDeleteConfirmationDialog)this.pageBinder.bind(BulkDeleteConfirmationDialog.class, new Object[]{this, this.bulkActionModal});
    }

    public BulkMoveConfirmationDialog getBulkMoveConfirmationDialog() {
        Poller.waitUntilTrue((TimedQuery)this.bulkActionModal.timed().isVisible());
        return (BulkMoveConfirmationDialog)this.pageBinder.bind(BulkMoveConfirmationDialog.class, new Object[]{this, this.bulkActionModal});
    }

    public DeleteConfirmationDialog getDeleteConfirmationDialog() {
        Poller.waitUntilTrue((TimedQuery)this.deleteModal.timed().isVisible());
        return (DeleteConfirmationDialog)this.pageBinder.bind(DeleteConfirmationDialog.class, new Object[]{this, this.deleteModal});
    }

    public MoveConfirmationDialog getMoveConfirmationDialog() {
        Poller.waitUntilTrue((TimedQuery)this.moveModal.timed().isVisible());
        return (MoveConfirmationDialog)this.pageBinder.bind(MoveConfirmationDialog.class, new Object[]{this, this.moveModal});
    }

    public LocationSelector getLocationSelector() {
        return (LocationSelector)this.pageBinder.bind(LocationSelector.class, new Object[]{this.locationFilter});
    }

    public ActivityFilter getActivityFilter() {
        return (ActivityFilter)this.pageBinder.bind(ActivityFilter.class, new Object[]{this.activityFilter});
    }

    public TimedQuery<List<RepositoryListItem>> getRepositories() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.table.findAll(By.cssSelector((String)"table > tbody > tr")).stream().map(e -> (RepositoryListItem)this.pageBinder.bind(RepositoryListItem.class, new Object[]{e, this})).collect(MoreCollectors.toImmutableList()));
    }

    public RepositoryListItem getRowMatching(Matcher<RepositoryListItem> matcher) {
        return ((List)Poller.waitUntil(this.getRepositories(), (Matcher)Matchers.not((Matcher)Matchers.empty()))).stream().filter(arg_0 -> matcher.matches(arg_0)).findFirst().orElseThrow(() -> {
            StringDescription description = new StringDescription();
            matcher.describeTo((Description)description);
            return new AssertionError((Object)("No row found matching " + description));
        });
    }

    public List<String> getHighlights() {
        return this.table.findAll(By.className((String)"highlighted-term")).stream().map(p -> p.getText()).collect(Collectors.toList());
    }

    public String getSelectAllState() {
        return this.selectAllCheckbox.getAttribute(SELECT_ALL_ATTR_CHECKED);
    }

    public PageElement getSelectionCount() {
        return this.selectionCount;
    }

    public Flag getSuccessAlert() {
        return this.getFlags().get(0);
    }

    public boolean isRelatedRepositoriesPage() {
        return this.elementFinder.find(By.className((String)"related-repositories-page")).isPresent();
    }

    public String getRelatedToRepositoryDetails() {
        return this.elementFinder.find(By.className((String)"repository-details")).getText();
    }

    public void clickGoBack() {
        this.elementFinder.find(By.className((String)"go-back")).click();
    }

    public void browserBack() {
        this.driver.navigate().back();
    }

    public String getUrl() {
        return "/admin/repository-management";
    }

    public TimedCondition isBulkDeleteVisible() {
        return this.bulkDeleteButton.timed().isVisible();
    }

    public TimedCondition isBulkMoveVisible() {
        return this.bulkMoveButton.timed().isVisible();
    }

    @WaitUntil
    public void waitForContent() {
        Poller.waitUntilTrue((TimedQuery)this.table.timed().isVisible());
    }
}

