/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.jira;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.By;

public class JiraCloudIntegrationsList
extends AbstractElementPageObject {
    public JiraCloudIntegrationsList(PageElement pageElement) {
        super(pageElement);
    }

    public Iterable<String> getColumnName() {
        return Iterables.transform(this.findAll(By.tagName((String)"th")), PageElement::getText);
    }

    public List<Entry> getRows() {
        Poller.waitUntilFalse((TimedQuery)this.container.find(By.cssSelector((String)".jira-cloud-integrations-list-spinner")).timed().isPresent());
        return Lists.transform((List)this.container.findAll(By.cssSelector((String)".jira-cloud-integration-row"), TimeoutType.PAGE_LOAD), ElementUtils.bind(this.pageBinder, Entry.class, new Object[0])::apply);
    }

    public static class Entry
    extends AbstractElementPageObject {
        public Entry(PageElement pageElement) {
            super(pageElement);
        }

        public String getName() {
            PageElement nameElement = this.find(By.cssSelector((String)".name"));
            return nameElement.getText();
        }

        public String getUrl() {
            PageElement urlElement = this.find(By.cssSelector((String)".url"));
            return urlElement.getText();
        }

        public String getClientId() {
            PageElement clientIdElement = this.find(By.cssSelector((String)".client-id"));
            return clientIdElement.getText();
        }

        public String getConnectionStatus() {
            PageElement connectionStatusElement = this.find(By.cssSelector((String)".connection-status"));
            return connectionStatusElement.getText();
        }

        public void delete() {
            PageElement actionsMenuTrigger = this.find(By.cssSelector((String)".jira-cloud-integration-actions button"));
            actionsMenuTrigger.click();
            PageElement deleteAction = this.find(By.cssSelector((String)"[data-testid=\"jira-cloud-integration-actions--content\"]"));
            deleteAction.click();
        }
    }
}

