/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.accesstokens;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.openqa.selenium.By;

public class AccessTokensSettingsPage
extends BitbucketPage {
    @ElementBy(id="are-you-sure-dialog")
    private PageElement confirmationDialog;
    @ElementBy(id="access-token-admin-expiry-disable")
    private AuiCheckbox disableExpiry;
    @ElementBy(id="access-token-admin-expiry-enable")
    private AuiCheckbox enableExpiry;
    @ElementBy(className="aui-button-primary")
    private PageElement save;
    @ElementBy(cssSelector=".aui-button-primary .aui-spinner")
    private PageElement spinner;
    @ElementBy(id="token-expiry")
    private PageElement tokenExpiry;

    public AccessTokensSettingsPage disableMaxExpiry(boolean confirm) {
        this.disableExpiry.click();
        if (confirm) {
            Poller.waitUntilTrue((TimedQuery)this.confirmationDialog.timed().isVisible());
            this.confirmationDialog.find(By.className((String)"confirm-button")).click();
        }
        Poller.waitUntil((TimedQuery)this.disableExpiry.timed().getAttribute("checked"), (Matcher)IsEqual.equalTo((Object)"true"));
        return this;
    }

    public AccessTokensSettingsPage enableMaxExpiry() {
        this.enableExpiry.click();
        Poller.waitUntil((TimedQuery)this.enableExpiry.timed().getAttribute("checked"), (Matcher)IsEqual.equalTo((Object)"true"));
        return this;
    }

    public String getUrl() {
        return "/plugins/servlet/access-tokens/admin";
    }

    public AccessTokensSettingsPage save() {
        Poller.waitUntilTrue((TimedQuery)this.save.timed().isEnabled());
        this.save.click();
        Poller.waitUntilTrue((TimedQuery)this.confirmationDialog.timed().isVisible());
        this.confirmationDialog.find(By.className((String)"confirm-button")).click();
        Poller.waitUntilFalse((TimedQuery)this.spinner.timed().isVisible());
        return this;
    }

    public AccessTokensSettingsPage setExpiry(String expiryDays) {
        this.tokenExpiry.clear().type(new CharSequence[]{expiryDays});
        Poller.waitUntil((TimedQuery)this.tokenExpiry.timed().getValue(), (Matcher)IsEqual.equalTo((Object)expiryDays));
        return this;
    }
}

