/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.requiredbuilds;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.requiredbuilds.RefMatcherEntry;
import com.atlassian.webdriver.bitbucket.element.requiredbuilds.RefMatcherEntryType;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class RefMatcherSelector
extends AbstractElementPageObject {
    private final PageElement branchModelSelector = this.find(By.className((String)"branch-model-selector"));
    private final PageElement branchSelector = this.find(By.className((String)"branch-selector"));
    private final PageElement patternInput = this.find(By.cssSelector((String)"[data-testid='enter-branch-pattern']"));
    private final PageElement selectAllBranches = this.find(By.cssSelector((String)"[data-testid='select-all-branches--radio-input']"));
    private final PageElement selectBranchName = this.find(By.cssSelector((String)"[data-testid='select-branch-name--radio-input']"));
    private final PageElement selectBranchPattern = this.find(By.cssSelector((String)"[data-testid='select-branch-pattern--radio-input']"));
    private final PageElement selectBranchingModel = this.find(By.cssSelector((String)"[data-testid='select-branching-model--radio-input']"));
    private final PageElement selectNone = this.find(By.cssSelector((String)"[data-testid='select-none--radio-input']"));

    public RefMatcherSelector(@Nonnull PageElement container) {
        super(container);
    }

    public RefMatcherEntry getRefMatcher() {
        if (this.selectAllBranches.isPresent() && this.selectAllBranches.isSelected()) {
            return new RefMatcherEntry(RefMatcherEntryType.ANY_BRANCH, "");
        }
        if (this.selectBranchName.isSelected()) {
            String branch = this.branchSelector.find(By.className((String)"filterable-tabs__single-value")).getText();
            return new RefMatcherEntry(RefMatcherEntryType.BRANCH_NAME, branch);
        }
        if (this.selectBranchPattern.isSelected()) {
            String pattern = this.patternInput.getValue();
            return new RefMatcherEntry(RefMatcherEntryType.BRANCH_PATTERN, pattern);
        }
        if (this.selectBranchingModel.isSelected()) {
            String branchModel = this.branchModelSelector.find(By.cssSelector((String)".model-name")).getText();
            return new RefMatcherEntry(RefMatcherEntryType.BRANCH_MODEL, branchModel);
        }
        return new RefMatcherEntry(RefMatcherEntryType.NONE, "");
    }

    public void selectAllBranches() {
        this.selectAllBranches.click();
    }

    public void selectNone() {
        this.selectNone.click();
    }

    public void selectBranch(String branchName) {
        this.selectBranchName.click();
        PageElement input = this.branchSelector.find(By.tagName((String)"input"));
        input.type(new CharSequence[]{branchName});
        Poller.waitUntilFalse((TimedQuery)this.branchSelector.find(By.cssSelector((String)".filterable-tabs__indicators circle")).timed().isPresent());
        input.type(new CharSequence[]{Keys.ENTER});
    }

    public void selectBranchPattern(String pattern) {
        this.selectBranchPattern.click();
        this.patternInput.type(new CharSequence[]{pattern});
    }

    public void selectBranchingModel(String branchModel) {
        this.selectBranchingModel.click();
        this.branchModelSelector.click();
        this.branchModelSelector.findAll(By.className((String)"branch-model-selector__option")).stream().map(option -> option.find(By.className((String)"model-name"))).filter(option -> branchModel.equals(option.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)("There is no branch model with model-name " + branchModel))).click();
    }
}

