/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.hooks;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.hooks.RepositoryHookSettingsDialog;
import com.atlassian.webdriver.bitbucket.page.admin.hooks.RepositoryHooksPage;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.openqa.selenium.By;

public abstract class RepositoryHookRow
extends AbstractElementPageObject {
    protected final RepositoryHooksPage parent;

    RepositoryHookRow(@Nonnull PageElement row, @Nonnull RepositoryHooksPage parent) {
        super(row);
        this.parent = Objects.requireNonNull(parent, "parent");
    }

    public abstract RepositoryHookRow bind();

    public RepositoryHookRow edit(@Nonnull Consumer<RepositoryHookSettingsDialog> callback) {
        PageElement editButton = this.find(By.cssSelector((String)".hook-edit-cell .aui-button"));
        this.find(By.className((String)"hook-summary-cell")).click();
        Poller.waitUntilTrue((TimedQuery)editButton.timed().isVisible());
        editButton.click();
        RepositoryHookSettingsDialog dialog = (RepositoryHookSettingsDialog)((Object)this.pageBinder.bind(RepositoryHookSettingsDialog.class, new Object[]{By.id((String)"hook-config-dialog"), this}));
        Poller.waitUntil((TimedQuery)dialog.isOpen(), (Matcher)IsEqual.equalTo((Object)true));
        callback.accept(dialog);
        Poller.waitUntil((TimedQuery)dialog.isOpen(), (Matcher)IsEqual.equalTo((Object)false));
        return this.bind();
    }

    public String getDescription() {
        return this.find(By.className((String)"hook-description")).getText();
    }

    public String getName() {
        return this.find(By.className((String)"hook-summary-cell")).find(By.tagName((String)"h4")).getText();
    }

    public abstract TimedQuery<HookState> getState();

    public RepositoryHookRow setState(HookState hookState) {
        RepositoryHookRow hook = this.setState(hookState, null);
        Poller.waitUntil(hook.getState(), (Matcher)IsEqual.equalTo((Object)((Object)hookState)));
        return hook;
    }

    public RepositoryHookRow setState(HookState hookState, @Nullable Consumer<RepositoryHookSettingsDialog> callback) {
        this.selectState(hookState);
        if (callback != null) {
            RepositoryHookSettingsDialog dialog = (RepositoryHookSettingsDialog)((Object)this.pageBinder.bind(RepositoryHookSettingsDialog.class, new Object[]{By.id((String)"hook-config-dialog"), this}));
            Poller.waitUntil((TimedQuery)dialog.isOpen(), (Matcher)IsEqual.equalTo((Object)true));
            callback.accept(dialog);
            Poller.waitUntil((TimedQuery)dialog.isOpen(), (Matcher)IsEqual.equalTo((Object)false));
        }
        return this.bind();
    }

    protected abstract void selectState(HookState var1);

    public static enum HookState {
        ENABLED,
        DISABLED,
        INHERITED_ENABLED,
        INHERITED_DISABLED;

    }
}

