/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.dashboard;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.page.BranchCreationPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class DashboardJiraIssuesSection
extends AbstractElementPageObject {
    public DashboardJiraIssuesSection(@Nonnull PageElement container) {
        super(container);
    }

    public void clickShowMore() {
        final int initialCount = this.getJiraIssueRows().size();
        PageElement showMoreButton = this.container.find(By.className((String)"show-more"));
        ElementUtils.scrollIntoView(showMoreButton);
        showMoreButton.click();
        Poller.waitUntilTrue((String)"The number of visible issues has increased", (TimedQuery)new AbstractTimedCondition(5000L, 100L){

            protected Boolean currentValue() {
                return DashboardJiraIssuesSection.this.getJiraIssueRows().size() > initialCount;
            }
        });
    }

    public AuthenticationRequiredState getAuthenticationRequiredState() {
        this.waitUntilReady();
        PageElement element = this.container.find(By.className((String)"authentication-required"));
        return (AuthenticationRequiredState)this.pageBinder.bind(AuthenticationRequiredState.class, new Object[]{element});
    }

    public EmptyState getEmptyState() {
        this.waitUntilReady();
        PageElement element = this.container.find(By.className((String)"empty-state"));
        return (EmptyState)this.pageBinder.bind(EmptyState.class, new Object[]{element});
    }

    public List<JiraIssueRow> getJiraIssueRows() {
        this.waitUntilReady();
        return this.container.findAll(By.className((String)"dashboard-jira-issue-row")).stream().map(ElementUtils.bind(this.pageBinder, JiraIssueRow.class, new Object[0])).collect(Collectors.toList());
    }

    public String getSelectedJiraServer() {
        return (String)this.container.find(By.className((String)"selected-jira-server")).timed().getText().byDefaultTimeout();
    }

    private void waitUntilReady() {
        Poller.waitUntilFalse((TimedQuery)this.container.find(By.className((String)"issues-spinner")).timed().isVisible());
    }

    public static class JiraIssueRow
    extends AbstractElementPageObject {
        public JiraIssueRow(@Nonnull PageElement container) {
            super(container);
        }

        public BranchCreationPage clickCreateBranch() {
            PageElement actionsCell = this.container.find(By.className((String)"actions-column"));
            PageElement actionMenu = actionsCell.find(By.tagName((String)"button"));
            ElementUtils.scrollIntoView(actionMenu);
            actionMenu.click();
            PageElement createBranchLink = actionsCell.find(By.cssSelector((String)"[role=\"menuitem\"]"));
            Poller.waitUntilTrue((TimedQuery)createBranchLink.timed().isVisible());
            createBranchLink.click();
            return (BranchCreationPage)this.pageBinder.bind(BranchCreationPage.class, new Object[0]);
        }

        public LinkElement getIssueKeyLink() {
            return (LinkElement)((Object)this.pageBinder.bind(LinkElement.class, new Object[]{this.container.find(By.className((String)"key-column"))}));
        }

        public String getStatus() {
            return (String)this.container.find(By.className((String)"status-column")).timed().getText().byDefaultTimeout();
        }

        public String getSummary() {
            return (String)this.container.find(By.className((String)"summary-column")).timed().getText().byDefaultTimeout();
        }

        public <T> T openIssueDialog(Class<T> issueDialogClass, Object ... bindArgs) {
            LinkElement issueKey = this.getIssueKeyLink();
            ElementUtils.scrollIntoView((PageElement)this.getIssueKeyLink());
            issueKey.click();
            return (T)this.pageBinder.bind(issueDialogClass, bindArgs);
        }
    }

    public static class EmptyState
    extends AbstractElementPageObject {
        public EmptyState(@Nonnull PageElement container) {
            super(container);
        }

        public LinkElement getLinkToJira() {
            return (LinkElement)((Object)this.pageBinder.bind(LinkElement.class, new Object[]{this.container.find(By.tagName((String)"a"))}));
        }
    }

    public static class AuthenticationRequiredState
    extends AbstractElementPageObject {
        public AuthenticationRequiredState(@Nonnull PageElement container) {
            super(container);
        }

        public <T> T clickAuthenticateLink(Class<T> pageClass, Object ... bindArgs) {
            PageElement authenticate = this.container.find(By.tagName((String)"a"));
            ElementUtils.scrollIntoView(authenticate);
            authenticate.click();
            return (T)this.pageBinder.bind(pageClass, bindArgs);
        }
    }
}

