/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.builds;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.builds.BuildActionsMenu;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class BuildResultRow
extends AbstractElementPageObject {
    private final PageElementFinder elementFinder;

    public BuildResultRow(@Nonnull PageElementFinder elementFinder, @Nonnull PageElement container) {
        super(container);
        this.elementFinder = Objects.requireNonNull(elementFinder, "elementFinder");
    }

    public String getArtifactLink() {
        return this.container.find(By.className((String)"build-row-artifacts")).find(By.tagName((String)"a")).getAttribute("href");
    }

    public String getCommitAuthor() {
        return this.container.find(By.className((String)"build-additional-details")).find(By.className((String)"build-commit-author")).getText();
    }

    public String getCommitHash() {
        return this.container.find(By.className((String)"build-commit-id")).find(By.tagName((String)"a")).getText();
    }

    public String getCommitMessage() {
        return this.container.find(By.className((String)"build-additional-details")).find(By.className((String)"build-commit-message")).getText();
    }

    public String getDate() {
        return this.container.find(By.className((String)"build-row-time")).find(By.tagName((String)"time")).getAttribute("datetime");
    }

    public String getDuration() {
        return this.container.find(By.className((String)"build-row-duration")).getText();
    }

    public String getLogLink() {
        return this.container.find(By.className((String)"build-row-logs")).find(By.tagName((String)"a")).getAttribute("href");
    }

    public String getPrimarySummary() {
        return this.container.find(By.className((String)"build-status-label-primary")).getText();
    }

    public String getResultLink() {
        return this.container.find(By.className((String)"build-title")).find(By.tagName((String)"a")).getAttribute("href");
    }

    public String getResultName() {
        return this.container.find(By.className((String)"build-title")).find(By.tagName((String)"a")).getText();
    }

    public String getSecondarySummary() {
        return this.container.find(By.className((String)"build-status-label-secondary")).getText();
    }

    public String getState() {
        return this.container.find(By.className((String)"build-status")).getAttribute("data-status");
    }

    public BuildActionsMenu openBuildActions() {
        this.container.find(By.className((String)"build-actions")).click();
        PageElement dropList = this.container.find(By.cssSelector((String)"[data-role=\"droplistContent\"]"));
        Poller.waitUntilTrue((TimedQuery)dropList.timed().isVisible());
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)"[data-testid=build-actions-loading-spinner]")).timed().isVisible());
        return new BuildActionsMenu(this.elementFinder, dropList);
    }
}

