/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.page.FormPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestOverviewPage;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.PullRequestDetails;
import com.atlassian.webdriver.bitbucket.element.RefLozenge;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.element.SourceTargetSelector;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import javax.inject.Inject;
import org.openqa.selenium.WebDriver;

@Deprecated
public class PullRequestCreatePage
extends BitbucketPage {
    private final String sourceProjectKey;
    private final String sourceSlug;
    private final String targetProjectKey;
    private final String targetSlug;
    @ElementBy(id="show-create-pr-button")
    private PageElement continueButton;
    @ElementBy(className="expanded-branches")
    private PageElement expandedBranches;
    private SourceTargetSelector sourceTargetSelector;

    public PullRequestCreatePage(String sourceProjectKey, String sourceSlug) {
        this.sourceProjectKey = sourceProjectKey;
        this.sourceSlug = sourceSlug;
        this.targetProjectKey = sourceProjectKey;
        this.targetSlug = sourceSlug;
    }

    public PullRequestCreatePage(String sourceProjectKey, String sourceSlug, String targetProjectKey) {
        this.sourceProjectKey = sourceProjectKey;
        this.sourceSlug = sourceSlug;
        this.targetProjectKey = targetProjectKey;
        this.targetSlug = sourceSlug;
    }

    public PullRequestCreatePage(String sourceProjectKey, String sourceSlug, String targetProjectKey, String targetSlug) {
        this.sourceProjectKey = sourceProjectKey;
        this.sourceSlug = sourceSlug;
        this.targetProjectKey = targetProjectKey;
        this.targetSlug = targetSlug;
    }

    public boolean canContinue() {
        return (Boolean)this.continueButton.timed().isEnabled().byDefaultTimeout();
    }

    public PullRequestCreateDetailsPage clickContinue() {
        this.continueButton.click();
        return (PullRequestCreateDetailsPage)this.pageBinder.bind(PullRequestCreateDetailsPage.class, new Object[]{this.sourceProjectKey, this.sourceSlug, this.targetProjectKey, this.targetSlug});
    }

    public SearchableSelector getSourceBranchSelector() {
        return this.sourceTargetSelector.getSourceBranchSelector();
    }

    public SearchableSelector getSourceRepositorySelector() {
        return ((SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0])).getSourceRepositorySelector();
    }

    public SearchableSelector getTargetBranchSelector() {
        return this.sourceTargetSelector.getTargetBranchSelector();
    }

    public SearchableSelector getTargetRepositorySelector() {
        return ((SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0])).getTargetRepositorySelector();
    }

    public String getUrl() {
        if (this.sourceProjectKey.startsWith("~")) {
            return String.format("/users/%s/repos/%s/pull-requests?create", this.sourceProjectKey.substring(1), this.sourceSlug);
        }
        return String.format("/projects/%s/repos/%s/pull-requests?create", this.sourceProjectKey, this.sourceSlug);
    }

    public boolean isShowingBranchSelector() {
        return (Boolean)this.expandedBranches.timed().isVisible().byDefaultTimeout();
    }

    @Init
    private void init() {
        this.sourceTargetSelector = (SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0]);
    }

    public static class PullRequestCreateDetailsPage
    extends FormPage<PullRequestOverviewPage> {
        private final String sourceProjectKey;
        private final String sourceRepoSlug;
        private final String targetProjectKey;
        private final String targetRepoSlug;
        @ElementBy(id="cancel-button")
        private PageElement cancelButton;
        @ElementBy(cssSelector=".branch-change.show-hide-button")
        private PageElement changeButton;
        @ElementBy(className="collapsed-branches")
        private PageElement collapsedBranches;
        @ElementBy(className="pull-request-details")
        private PageElement details;
        @ElementBy(cssSelector=".aui-lozenge.source-branch")
        private RefLozenge sourceBranch;
        private SourceTargetSelector sourceTargetSelector;
        @ElementBy(cssSelector=".aui-lozenge.target-branch")
        private RefLozenge targetBranch;
        @Inject
        private WebDriver webDriver;

        public PullRequestCreateDetailsPage(String sourceProjectKey, String sourceRepoSlug, String targetProjectKey, String targetRepoSlug) {
            this.sourceProjectKey = sourceProjectKey;
            this.sourceRepoSlug = sourceRepoSlug;
            this.targetProjectKey = targetProjectKey;
            this.targetRepoSlug = targetRepoSlug;
        }

        public PullRequestCreatePage clickCancel() {
            this.cancelButton.click();
            return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.sourceProjectKey, this.sourceRepoSlug, this.targetProjectKey});
        }

        public PullRequestCreatePage clickChange() {
            this.changeButton.click();
            return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.sourceProjectKey, this.sourceRepoSlug, this.targetProjectKey});
        }

        public PullRequestCreateDetailsPage clickSubmitExpectingErrors() {
            return (PullRequestCreateDetailsPage)super.clickSubmitExpectingErrors(this.sourceProjectKey, this.sourceRepoSlug, this.targetProjectKey, this.targetRepoSlug);
        }

        public RefLozenge getCollapsedSourceBranch() {
            return this.sourceBranch;
        }

        public RefLozenge getCollapsedTargetBranch() {
            return this.targetBranch;
        }

        public PullRequestDetails getDetails() {
            return (PullRequestDetails)((Object)this.pageBinder.bind(PullRequestDetails.class, new Object[]{this.details}));
        }

        public String getUrl() {
            if (this.sourceProjectKey.startsWith("~")) {
                return String.format("/users/%s/repos/%s/pull-requests?create", this.sourceProjectKey.substring(1), this.sourceRepoSlug);
            }
            return String.format("/projects/%s/repos/%s/pull-requests?create", this.sourceProjectKey, this.sourceRepoSlug);
        }

        public boolean isShowingPRForm() {
            return (Boolean)this.collapsedBranches.timed().isVisible().byDefaultTimeout() != false && (Boolean)this.details.timed().isVisible().byDefaultTimeout() != false;
        }

        @Override
        protected PullRequestOverviewPage getResponsePage() {
            String pullRequestPageURL = this.webDriver.getCurrentUrl();
            String[] pathArray = pullRequestPageURL.split("/");
            long pullRequestId = Long.parseLong(pathArray[pathArray.length - 2]);
            return (PullRequestOverviewPage)this.pageBinder.bind(PullRequestOverviewPage.class, new Object[]{this.targetProjectKey, this.targetRepoSlug, pullRequestId});
        }
    }
}

