/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RefSelector
extends AbstractElementPageObject {
    private final PageElement menuList = this.find(By.className((String)"filterable-tabs__menu-list"));
    private final PageElement menuSpinner = this.find(By.className((String)"filterable-tabs__menu-notice--loading"));
    private final PageElement searchInput = this.find(By.cssSelector((String)".filterable-tabs__input input"));
    private final PageElement searchInputSpinner = this.find(By.cssSelector((String)".filterable-tabs__indicators circle"));
    private final PageElement selector = this.find(By.className((String)"filterable-tabs-selector"));
    private final PageElement tabsList = this.find(By.cssSelector((String)".tabs-control-component [role='tablist']"));
    private final PageElement toggleButton = this.find(By.className((String)"selector-toggle-button"));

    public RefSelector(@Nonnull PageElement container) {
        super(container);
    }

    public RefSelector clickOption(String optionLabel) {
        this.getOption(optionLabel).click();
        return this;
    }

    public boolean hasOption(String optionLabel) {
        return this.getOption(optionLabel).isPresent();
    }

    public void loadNextPage() {
        this.menuList.javascript().execute("const menuList = arguments[0];menuList.scrollTop = menuList.scrollHeight;menuList.dispatchEvent(new WheelEvent('wheel', { deltaY: 10 }));", new Object[0]);
        this.waitUntilLoaded();
    }

    public RefSelector clickTab(Tab tab) {
        this.getTab(tab).click();
        this.searchInput.click();
        return this;
    }

    public List<PageElement> getResults() {
        return this.container.findAll(By.cssSelector((String)"[data-testid='option']:not([data-test-value='no-value'])"));
    }

    public String getValue() {
        return this.hasValue() ? this.toggleButton.getText() : null;
    }

    public boolean hasValue() {
        return this.toggleButton.hasClass("has-value");
    }

    public RefSelector open() {
        this.toggleButton.click();
        Poller.waitUntilTrue((TimedQuery)this.isOpen());
        return this;
    }

    public RefSelector search(String searchQuery) {
        this.searchInput.type(new CharSequence[]{searchQuery});
        this.waitUntilLoaded();
        return this;
    }

    public void searchAndSelectBranch(String branch) {
        this.searchAndSelectValue(branch, Tab.BRANCHES);
    }

    public void searchAndSelectCommit(String commit) {
        this.searchAndSelectValue(commit, Tab.COMMITS);
    }

    public void searchAndSelectTag(String tag) {
        this.searchAndSelectValue(tag, Tab.TAGS);
    }

    private PageElement getTab(Tab tab) {
        return this.tabsList.findAll(By.cssSelector((String)"[role='tab']")).stream().filter(name -> tab.toString().equalsIgnoreCase(name.getText())).findFirst().orElse(null);
    }

    private TimedCondition isOpen() {
        return this.selector.timed().isVisible();
    }

    private void searchAndSelectValue(String value, Tab tab) {
        this.open().clickTab(tab).search(value).clickOption(value);
    }

    private PageElement getOption(String optionLabel) {
        String dataTestLabel = String.format("[data-test-label='%s']", optionLabel);
        return this.find(By.cssSelector((String)dataTestLabel));
    }

    private void waitUntilLoaded() {
        Poller.waitUntilFalse((TimedQuery)this.searchInputSpinner.timed().isVisible());
        Poller.waitUntilFalse((TimedQuery)this.menuSpinner.timed().isVisible());
    }

    public static enum Tab {
        BRANCHES,
        TAGS,
        COMMITS;

    }
}

