/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class DropdownMenu
extends AbstractElementPageObject {
    private final PageElement menu;
    private final PageElement trigger;

    public DropdownMenu(@Nonnull PageElement parentContainer, String testId) {
        super(parentContainer);
        this.menu = this.find(By.cssSelector((String)("[data-testid='" + testId + "--content']")));
        this.trigger = this.find(By.cssSelector((String)("[data-testid='" + testId + "--trigger']")));
    }

    public void clickMenuItem(String itemName) {
        this.trigger.click();
        this.getMenuItemByName(itemName).click();
    }

    private PageElement getMenuItemByName(String itemName) {
        return this.menu.findAll(By.cssSelector((String)"[role='menuitem']")).stream().filter(menuItem -> itemName.equalsIgnoreCase(menuItem.getText())).findFirst().orElse(null);
    }
}

