/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.BinaryDiffFileContent;
import com.atlassian.bitbucket.pageobjects.element.DiffFileContentLine;
import com.atlassian.bitbucket.pageobjects.element.DiffToolbar;
import com.atlassian.bitbucket.pageobjects.element.FileContent;
import com.atlassian.bitbucket.pageobjects.element.comments.Comment;
import com.atlassian.bitbucket.pageobjects.element.comments.CommentForm;
import com.atlassian.bitbucket.pageobjects.element.comments.DiffFileCommentForm;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class DiffFileContent
extends FileContent {
    private final PageElement binaryDiff = this.find(By.className((String)"diff-binary"));
    private final PageElement conflictBanner = this.find(By.cssSelector((String)"[data-testid='diff-file-conflict']"));

    public DiffFileContent(@Nonnull PageElement container) {
        super(container);
    }

    public Comment addFileComment(String commentText) {
        return this.startFileComment(commentText).submitComment();
    }

    public DiffFileContentLine getActiveDiffLine() {
        PageElement activeDiffLine = (PageElement)this.waitForSourceContainer(() -> this.find(By.cssSelector((String)".active-diff-line + .diff-line")));
        return (DiffFileContentLine)this.pageBinder.bind(DiffFileContentLine.class, new Object[]{activeDiffLine});
    }

    public List<Comment> getAllComments() {
        return (List)this.container.withTimeout(TimeoutType.SLOW_PAGE_LOAD).findAll(By.className((String)"comment-with-replies")).stream().map(ElementUtils.bind(this.pageBinder, Comment.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    public BinaryDiffFileContent getBinaryDiff() {
        Poller.waitUntilTrue((TimedQuery)this.binaryDiff.timed().isVisible());
        return (BinaryDiffFileContent)this.pageBinder.bind(BinaryDiffFileContent.class, new Object[]{this.binaryDiff});
    }

    public String getConflictBannerMessage() {
        return this.conflictBanner.find(By.tagName((String)"h1")).getText();
    }

    public List<DiffFileContentLine> getDiffLines() {
        return (List)this.waitForSourceContainer(() -> (List)this.container.findAll(By.className((String)"diff-line")).stream().map(ElementUtils.bind(this.pageBinder, DiffFileContentLine.class, new Object[0])).collect(MoreCollectors.toImmutableList()));
    }

    public List<PageElement> getDiffSegmentElements() {
        return this.container.findAll(By.className((String)"diff-segment"));
    }

    public Comment getLatestFileComment() {
        PageElement commentElement = this.find(By.cssSelector((String)".diff-comments > .comments-thread:last-child"));
        Poller.waitUntilTrue((TimedQuery)commentElement.timed().isVisible());
        return (Comment)this.pageBinder.bind(Comment.class, new Object[]{commentElement});
    }

    public DiffToolbar getToolbar() {
        return (DiffToolbar)this.waitForSourceContainer(() -> (DiffToolbar)this.pageBinder.bind(DiffToolbar.class, new Object[]{this.find(By.className((String)"change-header"))}));
    }

    public boolean hasConflictBanner() {
        return this.conflictBanner.isPresent();
    }

    public CommentForm startFileComment(String message) {
        CommentForm commentForm = this.openFileCommentForm();
        return (CommentForm)commentForm.setText(message);
    }

    private CommentForm openFileCommentForm() {
        this.getToolbar().clickAddFileComment();
        return (CommentForm)this.pageBinder.bind(DiffFileCommentForm.class, new Object[]{this.find(By.cssSelector((String)".additional-diff-content .comment-editor")), this});
    }
}

