/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.CommitItem;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class CommitsTable
extends AbstractElementPageObject {
    private final PageElement tableSpinner = this.find(By.className((String)"commits-table-spinner"));

    public CommitsTable(@Nonnull PageElement container) {
        super(container);
        this.waitUntilLoaded();
    }

    public List<CommitItem> getCommits() {
        return (List)this.container.find(By.tagName((String)"tbody")).findAll(By.tagName((String)"tr")).stream().map(commit -> (CommitItem)this.pageBinder.bind(CommitItem.class, new Object[]{commit})).collect(MoreCollectors.toImmutableList());
    }

    public CommitsTable loadMoreCommits() {
        ElementUtils.scrollDocument(this.container);
        Poller.waitUntilFalse((TimedQuery)this.tableSpinner.timed().isPresent());
        return this;
    }

    private void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isPresent());
        Poller.waitUntilFalse((TimedQuery)this.tableSpinner.timed().isPresent());
    }
}

