/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Avatar;
import com.atlassian.webdriver.bitbucket.element.PullRequestDeclineDialog;
import com.atlassian.webdriver.bitbucket.element.PullRequestDeleteDialog;
import com.atlassian.webdriver.bitbucket.element.PullRequestEditDialog;
import com.atlassian.webdriver.bitbucket.element.PullRequestMergeConfirmDialog;
import com.atlassian.webdriver.bitbucket.element.PullRequestRemoveSelfDialog;
import com.atlassian.webdriver.bitbucket.element.PullRequestTabs;
import com.atlassian.webdriver.bitbucket.element.TabItem;
import com.atlassian.webdriver.bitbucket.element.activity.MergeButton;
import com.atlassian.webdriver.bitbucket.element.activity.ToolbarButton;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestCommitDiffPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestCommitsPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestEffectiveDiffPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestIterativeDiffPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestOverviewPage;
import com.atlassian.webdriver.bitbucket.util.KeyboardShortcuts;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PullRequestPage<T extends PullRequestPage<T>>
extends BaseRepositoryPage {
    private static final Logger log = LoggerFactory.getLogger(PullRequestPage.class);
    @ElementBy(cssSelector=".content-body .aui-page-panel-content > .aui-tabs")
    protected PullRequestTabs pullRequestTabs;
    @ElementBy(cssSelector=".pull-request-content .author-avatar-item .user-avatar")
    private Avatar authorAvatar;
    @ElementBy(cssSelector=".pull-request-content .author")
    private PageElement authorField;
    @ElementBy(cssSelector=".pull-request-more-trigger")
    private PageElement moreButton;
    @ElementBy(cssSelector=".ref-name-from")
    private PageElement sourceBranchLozengeName;
    @ElementBy(cssSelector=".ref-name-to")
    private PageElement targetBranchLozengeName;
    @ElementBy(cssSelector=".pull-request-header h2")
    private PageElement titleField;
    @ElementBy(cssSelector=".pull-request-header h2 a")
    private PageElement titleLink;
    @ElementBy(cssSelector="#edit-pull-request-dialog")
    private PageElement editDialog;
    @Inject
    private PageElementActions actions;
    private long pullRequestId;

    public PullRequestPage(String projectKey, String slug, long pullRequestId) {
        super(projectKey, slug);
        this.pullRequestId = pullRequestId;
    }

    public void addSelfAsReviewer() {
        this.getAddSelfButton().clickButton();
        this.actions.moveToElement(this.elementFinder.find(By.tagName((String)"body"))).click();
    }

    public boolean canEdit() {
        return this.content.find(this.getMoreButtonSelector("edit")).isPresent();
    }

    @Override
    public void doWait() {
        if (this.pullRequestId == 0L) {
            String url = this.driver.getCurrentUrl();
            try {
                this.pullRequestId = Long.parseLong(StringUtils.substringAfter((String)url, (String)"/pull-requests/").split("/")[0]);
            }
            catch (NumberFormatException e) {
                log.warn("Error parsing pull request id in {}", (Object)url, (Object)e);
            }
        }
        super.doWait();
    }

    public void editWithShortcut() {
        KeyboardShortcuts.editPullRequest(this.body);
    }

    public ToolbarButton<T> getAddSelfButton() {
        return this.getToolbarButton("add-self .aui-button", this.noSpinner());
    }

    public ToolbarButton<T> getApproveButton() {
        return this.getToolbarButton("approve", this.noSpinner());
    }

    public ToolbarButton<PullRequestDeclineDialog<T>> getDeclineButton() {
        return this.getToolbarButtonInMore("decline", () -> (PullRequestDeclineDialog)((Object)((Object)this.pageBinder.bind(PullRequestDeclineDialog.class, new Object[]{By.id((String)"pull-request-decline-dialog"), TimeoutType.DIALOG_LOAD, this}))));
    }

    public ToolbarButton<PullRequestDeleteDialog> getDeleteButton() {
        return this.getToolbarButtonInMore("delete", () -> (PullRequestDeleteDialog)((Object)((Object)this.pageBinder.bind(PullRequestDeleteDialog.class, new Object[]{By.id((String)"pull-request-delete-dialog"), TimeoutType.DIALOG_LOAD, this.projectKey, this.slug}))));
    }

    public TabItem getDiffTab() {
        return this.pullRequestTabs.getTab("Diff");
    }

    public ToolbarButton<PullRequestEditDialog<T>> getEditButton() {
        return this.getToolbarButtonInMore("edit", () -> (PullRequestEditDialog)((Object)((Object)this.pageBinder.bind(PullRequestEditDialog.class, new Object[]{By.id((String)"edit-pull-request-dialog"), TimeoutType.DIALOG_LOAD, this}))));
    }

    public PageElement getEditDialog() {
        return this.editDialog;
    }

    public String getFullSourceName() {
        return this.sourceBranchLozengeName.getAttribute("original-title");
    }

    public MergeButton<T> getMergeButton() {
        By locator = this.getToolbarButtonSelector("merge-button");
        return (MergeButton)((Object)this.pageBinder.bind(MergeButton.class, new Object[]{locator, TimeoutType.DEFAULT, this, () -> (PullRequestMergeConfirmDialog)((Object)((Object)this.pageBinder.bind(PullRequestMergeConfirmDialog.class, new Object[]{By.id((String)"pull-request-merge-dialog"), TimeoutType.DIALOG_LOAD, this})))}));
    }

    public ToolbarButton<T> getNeedsWorkButton() {
        return this.getToolbarButton("aui-button.needs-work", this.noSpinner());
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public String getPullRequestAuthor() {
        return this.authorField.getText();
    }

    public Avatar getPullRequestAuthorAvatar() {
        return this.authorAvatar;
    }

    public String getPullRequestTitle() {
        return this.titleField.getText();
    }

    public String getPullRequestTitleJiraIssueKey() {
        Poller.waitUntilTrue((TimedQuery)this.titleLink.timed().isPresent());
        return this.titleLink.getAttribute("data-issue-keys");
    }

    public PullRequestRemoveSelfDialog getRemoveSelfDialog() {
        this.content.find(By.className((String)"self-avatar")).select();
        return (PullRequestRemoveSelfDialog)this.pageBinder.bind(PullRequestRemoveSelfDialog.class, new Object[]{this});
    }

    public ToolbarButton<T> getReopenButton() {
        return this.getToolbarButton("reopen-button", this.noSpinner());
    }

    public String getSourceBranch() {
        return this.sourceBranchLozengeName.find(By.cssSelector((String)".branch-name")).getText();
    }

    public String getTargetBranch() {
        return this.targetBranchLozengeName.find(By.cssSelector((String)".branch-name")).getText();
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/pull-requests/" + String.valueOf(this.pullRequestId);
    }

    public ToolbarButton getWatchButton() {
        return this.getToolbarButtonInMore("watch", this.noSpinner());
    }

    public boolean isAddSelfButtonPresent() {
        return this.content.find(this.getToolbarButtonSelector("add-self .aui-button")).isPresent();
    }

    public PullRequestCommitDiffPage switchToCommitDiff(String commit) {
        this.scrollToTop();
        this.pullRequestTabs.clickDiffTab();
        return (PullRequestCommitDiffPage)this.pageBinder.bind(PullRequestCommitDiffPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId, commit});
    }

    public PullRequestCommitsPage switchToCommits() {
        this.scrollToTop();
        this.pullRequestTabs.clickCommitsTab();
        PullRequestCommitsPage page = (PullRequestCommitsPage)this.pageBinder.bind(PullRequestCommitsPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId});
        page.waitUntilCommitsTableLoaded();
        return page;
    }

    public PullRequestEffectiveDiffPage switchToEffectiveDiff() {
        this.scrollToTop();
        this.pullRequestTabs.clickDiffTab();
        return (PullRequestEffectiveDiffPage)this.pageBinder.bind(PullRequestEffectiveDiffPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId});
    }

    public PullRequestIterativeDiffPage switchToIterativeDiff(String since, String until) {
        this.scrollToTop();
        this.pullRequestTabs.clickDiffTab();
        return (PullRequestIterativeDiffPage)this.pageBinder.bind(PullRequestIterativeDiffPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId, since, until});
    }

    public PullRequestOverviewPage switchToOverview() {
        this.scrollToTop();
        this.pullRequestTabs.clickOverviewTab();
        return (PullRequestOverviewPage)this.pageBinder.bind(PullRequestOverviewPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId});
    }

    @WaitUntil
    public void waitUntilPageLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"pull-request-header")).timed().isPresent());
        Poller.waitUntilFalse((String)"The spinner is no longer active", (TimedQuery)Conditions.forSupplier(() -> this.elementFinder.findAll(By.cssSelector((String)".pull-request-activity-content .spinner > div")).size() > 0));
    }

    private By getMoreButtonSelector(String buttonDataAction) {
        return By.cssSelector((String)("#pull-request-header-more button[data-action='" + buttonDataAction + "']"));
    }

    private <X> ToolbarButton<X> getToolbarButton(String buttonClass, Supplier<X> supplier) {
        By locator = this.getToolbarButtonSelector(buttonClass);
        return (ToolbarButton)((Object)this.pageBinder.bind(ToolbarButton.class, new Object[]{locator, TimeoutType.DEFAULT, this, supplier}));
    }

    private <X> ToolbarButton<X> getToolbarButtonInMore(String buttonDataAction, Supplier<X> supplier) {
        if (!this.body.find(By.cssSelector((String)"#pull-request-header-more")).isVisible()) {
            this.moreButton.click();
        }
        By locator = this.getMoreButtonSelector(buttonDataAction);
        return (ToolbarButton)((Object)this.pageBinder.bind(ToolbarButton.class, new Object[]{locator, TimeoutType.DEFAULT, this, supplier}));
    }

    private By getToolbarButtonSelector(String buttonClass) {
        return By.cssSelector((String)(".pull-request-actions ." + buttonClass));
    }

    private Supplier<T> noSpinner() {
        return () -> this;
    }
}

