/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.Option;
import com.atlassian.pageobjects.elements.Options;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.SelectElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.PullRequestTable;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestCreatePage;
import com.atlassian.webdriver.bitbucket.page.PullRequestOverviewPage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import org.openqa.selenium.By;

public class PullRequestListPage
extends BaseRepositoryPage {
    private final Map<String, String> filters;
    @ElementBy(id="s2id_pr-author-filter")
    private PageElement authorFilter;
    @ElementBy(id="list-create-pr-button")
    private PageElement createActionButton;
    @ElementBy(id="pull-requests-content")
    private PageElement pullRequestTable;
    @ElementBy(id="pr-reviewer-self-filter")
    private PageElement reviewingFilter;
    @ElementBy(id="pr-state-filter")
    private SelectElement stateFilter;
    @ElementBy(id="s2id_pr-target-branch-filter")
    private PageElement targetBranchFilter;

    public PullRequestListPage(String projectKey, String slug) {
        this(projectKey, slug, Maps.newHashMap());
    }

    public PullRequestListPage(String projectKey, String slug, Map<String, String> filters) {
        super(projectKey, slug);
        this.filters = ImmutableMap.copyOf(filters);
    }

    public PullRequestCreatePage clickCreateActionButton() {
        this.createActionButton.click();
        return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.projectKey, this.slug});
    }

    public void filterByAuthor(String author) {
        this.filterByAuthor(author, author);
    }

    public void filterByAuthor(String author, String authorDisplayName) {
        this.filterByAsyncSelect(this.authorFilter, author, ".avatar-with-name[title^=\"" + this.escapeSelector(authorDisplayName) + "\"]", ".pr-author-dropdown");
    }

    public void filterByReviewerToggle() {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> this.reviewingFilter.click());
    }

    public void filterByState(PullRequestState state) {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> this.stateFilter.select((Option)Options.value((String)state.name())));
    }

    public void filterByTargetBranch(String branch) {
        this.filterByAsyncSelect(this.targetBranchFilter, branch, ".name[title=\"" + this.escapeSelector(branch) + "\"]", ".pr-target-branch-dropdown");
    }

    public PullRequestTable getPullRequestTable() {
        Poller.waitUntilFalse((TimedQuery)this.pullRequestTable.find(By.cssSelector((String)"aui-spinner")).timed().isPresent());
        return (PullRequestTable)this.pageBinder.bind(PullRequestTable.class, new Object[]{this.pullRequestTable});
    }

    public PullRequestTable.Entry getPullRequestTableEntry(long pullRequestId) {
        try {
            return (PullRequestTable.Entry)Iterables.find(this.getPullRequestTable().getRows(), row -> pullRequestId == row.getId());
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No pull request with ID " + pullRequestId + " in the list");
        }
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/pull-requests" + this.getQueryString();
    }

    public boolean isBuildStatusColumnVisible() {
        PageElement buildColumn = this.elementFinder.find(By.cssSelector((String)"th.build-status-pr-list-col"));
        return (Boolean)buildColumn.timed().isPresent().byDefaultTimeout() != false && (Boolean)buildColumn.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isCreateActionButtonVisible() {
        return (Boolean)this.createActionButton.timed().isPresent().byDefaultTimeout() != false && (Boolean)this.createActionButton.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isGettingStartedMessageVisible() {
        PageElement gettingStartedMessage = this.elementFinder.find(By.cssSelector((String)".pull-request-list .pull-request-intro"));
        return (Boolean)gettingStartedMessage.timed().isPresent().byDefaultTimeout() != false && (Boolean)gettingStartedMessage.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isNoResultsMessageVisible() {
        PageElement noMoreMessage = this.elementFinder.find(By.cssSelector((String)".pull-request-list .empty-banner-content"));
        return (Boolean)noMoreMessage.timed().isPresent().byDefaultTimeout() != false && (Boolean)noMoreMessage.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isNoMoreResultsMessageVisible() {
        PageElement noMoreResultsMessage = this.elementFinder.find(By.className((String)"paged-table-message"));
        return (Boolean)noMoreResultsMessage.timed().isPresent().byDefaultTimeout() != false && (Boolean)noMoreResultsMessage.timed().isVisible().byDefaultTimeout() != false;
    }

    public PullRequestOverviewPage navigateToPullRequest(long pullRequestId) {
        PageElement pullRequestLink = this.elementFinder.find(By.cssSelector((String)(".summary[data-pull-request-id=\"" + pullRequestId + "\"] .pull-request-title")));
        pullRequestLink.click();
        return (PullRequestOverviewPage)this.pageBinder.bind(PullRequestOverviewPage.class, new Object[]{this.projectKey, this.slug, pullRequestId});
    }

    private String escapeSelector(String s) {
        return s.replaceAll("\"", "\\\"");
    }

    private void filterByAsyncSelect(PageElement filter, String value, String resultSelector, String dropDownClassName) {
        PageElement choice = filter.find(By.cssSelector((String)"a.select2-choice"));
        Poller.waitUntilTrue((TimedQuery)choice.timed().isPresent());
        choice.click();
        PageElement searchBox = this.elementFinder.find(By.cssSelector((String)"#select2-drop input"));
        if (!((Boolean)searchBox.timed().isVisible().byDefaultTimeout()).booleanValue()) {
            choice.click();
            Poller.waitUntilTrue((TimedQuery)searchBox.timed().isPresent());
        }
        searchBox.click().clear().type(new CharSequence[]{value});
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#select2-drop .spinner .spinner")).timed().isPresent());
        PageElement selectDropdown = this.elementFinder.find(By.cssSelector((String)("#select2-drop:not([style*='display: none'])" + dropDownClassName)));
        selectDropdown.timed().isVisible();
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.pull.request.list.updated", () -> selectDropdown.find(By.cssSelector((String)("ul.select2-results li.select2-result-selectable " + resultSelector))).click());
    }

    private String getQueryString() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> entry : this.filters.entrySet()) {
            buffer.append(buffer.length() == 0 ? "?" : "&").append(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return buffer.toString();
    }
}

