/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.PullRequestCommitDiffPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestDiffPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestEffectiveDiffPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestIterativeDiffPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.openqa.selenium.By;

public class CommitSelector
extends AbstractElementPageObject {
    public CommitSelector(@Nonnull PageElement container) {
        super(container);
    }

    public List<CommitItem> getItems() {
        return this.container.findAll(By.cssSelector((String)"ul.commit-list > li.commit-list-item")).stream().filter(item -> !item.hasClass("preload-item")).map(ElementUtils.bind(this.pageBinder, CommitItem.class, new Object[0])).collect(Collectors.toList());
    }

    public List<Item> getPreloadItems() {
        return this.container.findAll(By.cssSelector((String)"ul.commit-list > li.preload-item")).stream().map(ElementUtils.bind(this.pageBinder, Item.class, new Object[0])).collect(Collectors.toList());
    }

    public Item getSelectedItem() {
        return this.container.findAll(By.cssSelector((String)"ul.commit-list > li.commit-list-item.selected")).stream().map(ElementUtils.bind(this.pageBinder, Item.class, new Object[0])).findFirst().get();
    }

    public boolean hasNoMoreCommits() {
        return this.container.find(By.className((String)"no-more-results")).isPresent();
    }

    public void scrollToBottom() {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.widget.pagedscrollable.dataLoaded", () -> this.container.javascript().execute("commitSelector = document.querySelector('#inline-dialog-commit-selector .commit-selector');commitSelector.scrollTop = commitSelector.scrollHeight;", new Object[0]));
    }

    public PullRequestEffectiveDiffPage selectAllChanges(PullRequestDiffPage page) {
        this.getPreloadItems().get(0).click();
        return (PullRequestEffectiveDiffPage)this.pageBinder.bind(PullRequestEffectiveDiffPage.class, new Object[]{page.getProjectKey(), page.getSlug(), page.getPullRequestId()});
    }

    public PullRequestCommitDiffPage selectCommit(PullRequestDiffPage page, String hash) {
        CommitItem item = this.getItems().stream().filter(i -> i.getCommitDisplayId().equals(hash.substring(0, 11))).findFirst().orElse(null);
        Assert.assertThat((String)"The commit to select should be in the commit list", (Object)item, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        item.click();
        return (PullRequestCommitDiffPage)this.pageBinder.bind(PullRequestCommitDiffPage.class, new Object[]{page.getProjectKey(), page.getSlug(), page.getPullRequestId(), hash});
    }

    public PullRequestIterativeDiffPage selectUnreviewedCommits(PullRequestDiffPage page, String sinceCommit, String untilCommit) {
        this.getPreloadItems().get(1).click();
        return (PullRequestIterativeDiffPage)this.pageBinder.bind(PullRequestIterativeDiffPage.class, new Object[]{page.getProjectKey(), page.getSlug(), page.getPullRequestId(), sinceCommit, untilCommit});
    }

    public static class Item
    extends AbstractElementPageObject {
        public Item(@Nonnull PageElement container) {
            super(container);
        }

        public void click() {
            this.container.click();
        }

        public boolean isItemDisabled() {
            return this.container.hasClass("disabled");
        }

        public String getText() {
            return this.getItemMessageDetails().getText();
        }

        protected PageElement getItemMessage() {
            return this.container.find(By.cssSelector((String)"a.commit-selector-item-message"));
        }

        protected PageElement getItemMessageDetails() {
            return this.container.find(By.cssSelector((String)"a.commit-selector-item-message > div.commit-selector-details"));
        }
    }

    public static class CommitItem
    extends Item {
        public CommitItem(@Nonnull PageElement container) {
            super(container);
        }

        public String getAuthor() {
            return this.getItemMessageDetails().find(By.cssSelector((String)"div.commit-badge-oneline span.commit-author")).getText();
        }

        public String getCommitDisplayId() {
            return this.getItemMessageDetails().find(By.cssSelector((String)"div.commit-badge-oneline span.commitid")).getText();
        }

        public String getCommitId() {
            return this.getItemMessage().getAttribute("data-id");
        }

        public String getCommitMessageBody() {
            return this.getItemMessageDetails().find(By.cssSelector((String)"div.commit-message > span.commit-message-body")).getText();
        }

        public String getCommitMessageSubject() {
            return this.getItemMessageDetails().find(By.cssSelector((String)"div.commit-message > span.commit-message-subject")).getText();
        }

        public int getCommitCommentCount() throws NumberFormatException {
            PageElement countElement = this.getItemMessageDetails().find(By.cssSelector((String)"div.commit-badge-oneline span.comment-count > .count"));
            if (!countElement.isPresent()) {
                return 0;
            }
            String countText = countElement.getText();
            if (StringUtils.isEmpty((CharSequence)countText)) {
                return 0;
            }
            return Integer.parseInt(countElement.getText());
        }
    }
}

