/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.util;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class DateUtils {
    private static final DateTimeFormatter SERVER_TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final DateTimeFormatter TEST_TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final FormatType DATE_TIME = new DateTimeFormatType("dd MMM - hh:mm a");
    public static final FormatType FULL = new DateTimeFormatType("dd MMMM yyyy hh:mm a");
    public static final FormatType LONG = new DateTimeFormatType("dd MMMM yyyy");
    public static final FormatType SHORT = new DateTimeFormatType("dd MMM yyyy");
    public static final FormatType TIME_ONLY = new DateTimeFormatType("hh:mm a");
    public static final FormatType TIME_STAMP = new InstantFormatType();

    @Nonnull
    public static ZonedDateTime parseServerTimestamp(@Nonnull String source) {
        return SERVER_TIMESTAMP_PATTERN.parse((CharSequence)source, ZonedDateTime::from);
    }

    @Nonnull
    public static ZonedDateTime parseTestTimestamp(@Nonnull String source) {
        return TEST_TIMESTAMP_PATTERN.parse((CharSequence)source, ZonedDateTime::from);
    }

    private static class DateTimeFormatType
    implements FormatType {
        private final DateTimeFormatter formatter;
        private final ZoneId timeZone;

        private DateTimeFormatType(String pattern) {
            this(DateTimeFormatter.ofPattern(pattern), ZoneId.systemDefault());
        }

        private DateTimeFormatType(DateTimeFormatter pattern, ZoneId timeZone) {
            this.formatter = pattern;
            this.timeZone = timeZone;
        }

        @Override
        public String formatTimestamp(@Nonnull String timestamp) {
            return this.formatter.format(DateUtils.parseTestTimestamp(timestamp).withZoneSameInstant(this.timeZone));
        }

        @Override
        @Nonnull
        public Matcher<String> matchesTimestamp(@Nonnull String timestamp) {
            return this.matchesTimestamp(DateUtils.parseTestTimestamp(timestamp));
        }

        @Override
        @Nonnull
        public Matcher<String> matchesTimestamp(@Nonnull ZonedDateTime zonedDateTime) {
            final String expectedTime = this.formatter.format(zonedDateTime.withZoneSameInstant(this.timeZone).truncatedTo(ChronoUnit.MINUTES));
            return new TypeSafeDiagnosingMatcher<String>(){

                protected boolean matchesSafely(String item, Description mismatchDescription) {
                    if (item.equalsIgnoreCase(expectedTime)) {
                        return true;
                    }
                    mismatchDescription.appendValue((Object)item);
                    return false;
                }

                public void describeTo(Description description) {
                    description.appendValue((Object)expectedTime);
                }
            };
        }

        @Override
        @Nonnull
        public FormatType withTimeZone(@Nonnull ZoneId id) {
            if (this.timeZone.equals(id)) {
                return this;
            }
            return new DateTimeFormatType(this.formatter, id);
        }

        @Override
        @Nonnull
        public FormatType withTimeZone(@Nonnull Optional<? extends ZoneId> id) {
            if (id.isPresent()) {
                return this.withTimeZone(id.get());
            }
            return this.withTimeZone(ZoneId.systemDefault());
        }
    }

    private static class InstantFormatType
    implements FormatType {
        private InstantFormatType() {
        }

        @Override
        public String formatTimestamp(@Nonnull String timestamp) {
            return SERVER_TIMESTAMP_PATTERN.format(DateUtils.parseServerTimestamp(timestamp));
        }

        @Override
        @Nonnull
        public Matcher<String> matchesTimestamp(@Nonnull String timestamp) {
            return this.matchesTimestamp(DateUtils.parseTestTimestamp(timestamp));
        }

        @Override
        @Nonnull
        public Matcher<String> matchesTimestamp(final @Nonnull ZonedDateTime expectedTime) {
            return new TypeSafeDiagnosingMatcher<String>(){

                protected boolean matchesSafely(String item, Description mismatchDescription) {
                    try {
                        ZonedDateTime actualItem = InstantFormatType.parse(item);
                        if (expectedTime.toInstant().equals(actualItem.toInstant())) {
                            return true;
                        }
                        mismatchDescription.appendValue((Object)this.toString(actualItem));
                        return false;
                    }
                    catch (DateTimeParseException e) {
                        mismatchDescription.appendValue((Object)item);
                        return false;
                    }
                }

                public void describeTo(Description description) {
                    description.appendValue((Object)this.toString(expectedTime));
                }

                private String toString(ZonedDateTime time) {
                    return String.format("%s [%d]", InstantFormatType.format(time), time.toInstant().toEpochMilli());
                }
            };
        }

        @Override
        @Nonnull
        public FormatType withTimeZone(@Nonnull ZoneId id) {
            return this;
        }

        @Override
        @Nonnull
        public FormatType withTimeZone(@Nonnull Optional<? extends ZoneId> id) {
            return this;
        }

        private static String format(ZonedDateTime data) {
            return SERVER_TIMESTAMP_PATTERN.format(data);
        }

        private static ZonedDateTime parse(String data) {
            return SERVER_TIMESTAMP_PATTERN.parse((CharSequence)data, ZonedDateTime::from);
        }
    }

    public static interface FormatType {
        public String formatTimestamp(@Nonnull String var1);

        @Nonnull
        public Matcher<String> matchesTimestamp(@Nonnull String var1);

        @Nonnull
        public Matcher<String> matchesTimestamp(@Nonnull ZonedDateTime var1);

        @Nonnull
        public FormatType withTimeZone(@Nonnull ZoneId var1);

        @Nonnull
        public FormatType withTimeZone(@Nonnull Optional<? extends ZoneId> var1);
    }
}

