/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.webhook;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.webhook.WebhookCreatePage;
import com.atlassian.webdriver.bitbucket.page.webhook.WebhookPage;
import javax.inject.Inject;

public class WebhookCreateResult {
    private final String projectKey;
    private final String repoSlug;
    @Inject
    private PageBinder pageBinder;
    @ElementBy(cssSelector=".field-group .error li")
    private PageElement errorIndicator;

    public WebhookCreateResult(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public WebhookPage expectSuccess() {
        return (WebhookPage)this.pageBinder.bind(WebhookPage.class, new Object[]{this.projectKey, this.repoSlug});
    }

    public WebhookCreatePage expectFailure() {
        Poller.waitUntilTrue((TimedQuery)this.errorIndicator.timed().isVisible());
        return (WebhookCreatePage)this.pageBinder.bind(WebhookCreatePage.class, new Object[]{this.projectKey, this.repoSlug});
    }
}

