/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.setup;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.setup.SetupAdminUserPage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupPage;
import org.openqa.selenium.By;

public final class SetupSettingsPage
extends SetupPage {
    @ElementBy(id="applicationTitle")
    private PageElement applicationTitleTextBox;
    @ElementBy(id="baseUrl")
    private PageElement baseUrlTextBox;
    @ElementBy(id="generate-license-button")
    private PageElement generateLicenseButton;
    @ElementBy(id="has-key-radio")
    private PageElement hasKeyRadioButton;
    @ElementBy(id="licenseHidden")
    private PageElement hideenLicenseInput;
    @ElementBy(id="license")
    private PageElement licenseTextBox;
    @ElementBy(id="no-account-button")
    private PageElement noAccountButton;
    @ElementBy(id="no-key-radio")
    private PageElement noKeyRadioButton;
    @ElementBy(id="submit")
    private PageElement submitButton;

    public SetupSettingsPage clearApplicationTitle() {
        this.applicationTitleTextBox.clear();
        return this;
    }

    public SetupSettingsPage clearBaseUrl() {
        this.baseUrlTextBox.clear();
        return this;
    }

    public SetupSettingsPage clearLicense() {
        this.licenseTextBox.clear();
        return this;
    }

    public SetupSettingsPage clickGenerateLicense() {
        this.generateLicenseButton.click();
        return this;
    }

    public SetupSettingsPage clickHasKey() {
        this.hasKeyRadioButton.click();
        return this;
    }

    public SetupAdminUserPage clickNext() {
        return (SetupAdminUserPage)this.clickNext(true);
    }

    public SetupPage clickNext(boolean successExpected) {
        this.waitForPageLoad(() -> this.submitButton.click());
        if (successExpected) {
            return (SetupPage)this.pageBinder.bind(SetupAdminUserPage.class, new Object[0]);
        }
        return (SetupPage)this.pageBinder.bind(SetupSettingsPage.class, new Object[0]);
    }

    public SetupSettingsPage clickNoAccount() {
        this.noAccountButton.click();
        return this;
    }

    public SetupSettingsPage clickNoKey() {
        this.noKeyRadioButton.click();
        return this;
    }

    public SetupSettingsPage enterApplicationTitle(String title) {
        this.applicationTitleTextBox.clear().type(new CharSequence[]{title});
        return this;
    }

    public SetupSettingsPage enterBaseURL(String url) {
        this.baseUrlTextBox.clear().type(new CharSequence[]{url});
        return this;
    }

    public SetupSettingsPage enterLicense(String licenseText) {
        this.licenseTextBox.clear().type(new CharSequence[]{licenseText});
        return this;
    }

    @Override
    public String getStepHeading() {
        return "Licensing and settings";
    }

    public boolean hasApplicationTitleWarning() {
        PageElement error = this.elementFinder.find(By.cssSelector((String)"#applicationTitle ~ .error"));
        return error.isPresent() && error.isVisible();
    }

    public boolean hasBaseURLWarning() {
        PageElement error = this.elementFinder.find(By.cssSelector((String)"#baseUrl ~ .error"));
        return error.isPresent() && error.isVisible();
    }

    public boolean hasLicenseWarning() {
        PageElement error = this.elementFinder.find(By.cssSelector((String)"#license ~ .error"));
        return error.isPresent() && error.isVisible();
    }
}

