/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.webdriver.bitbucket.page.CommitUnifiedDiffPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestDiffPage;
import org.openqa.selenium.By;

public class PullRequestCommitDiffPage
extends PullRequestDiffPage {
    private final String commitHash;

    public PullRequestCommitDiffPage(String projectKey, String slug, long pullRequestId, String commitHash) {
        this(projectKey, slug, pullRequestId, commitHash, null);
    }

    public PullRequestCommitDiffPage(String projectKey, String slug, long pullRequestId, String commitHash, String path) {
        super(projectKey, slug, pullRequestId, path);
        this.commitHash = commitHash;
    }

    public PullRequestCommitDiffPage(String projectKey, String slug, long pullRequestId, String commitHash, long commentId, String action) {
        super(projectKey, slug, pullRequestId, commentId, action);
        this.commitHash = commitHash;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public CommitUnifiedDiffPage visitStandaloneCommit() {
        this.elementFinder.find(By.cssSelector((String)".file-tree-header .commitid")).click();
        return (CommitUnifiedDiffPage)this.pageBinder.bind(CommitUnifiedDiffPage.class, new Object[]{this.getProjectKey(), this.getSlug(), this.getCommitHash()});
    }

    @Override
    public PullRequestDiffPage toggleOverview() {
        this.switchToOverview();
        this.pullRequestTabs.clickDiffTab();
        return (PullRequestDiffPage)this.pageBinder.bind(PullRequestCommitDiffPage.class, new Object[]{this.getProjectKey(), this.getSlug(), this.getPullRequestId(), this.commitHash});
    }

    @Override
    protected String getDiffUrl() {
        return "/commits/" + this.commitHash;
    }

    @Override
    protected String getExtraQueryParams() {
        return "";
    }
}

