/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.LicenseEditPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class LicensePage
extends BitbucketPage {
    @ElementBy(id="license-edit")
    private PageElement editButton;

    @WaitUntil
    public void waitUntilVisible() {
        Poller.waitUntilTrue((TimedQuery)this.editButton.timed().isVisible());
    }

    public String getUrl() {
        return "/admin/license";
    }

    public String getServerId() {
        return this.driver.findElement(By.id((String)"serverid")).getText();
    }

    public String getLicenseDescription() {
        return this.driver.findElement(By.id((String)"license-description")).getText();
    }

    public String getLicensee() {
        return this.driver.findElement(By.id((String)"license-owner")).getText();
    }

    public String getClustering() {
        return this.driver.findElement(By.id((String)"license-clustered")).getText();
    }

    public String getSEN() {
        return this.driver.findElement(By.id((String)"license-sen")).getText();
    }

    public String getExpiry() {
        return this.driver.findElement(By.id((String)"license-expiry")).getText();
    }

    public String getMaintenanceExpiry() {
        return this.driver.findElement(By.id((String)"license-maintenance-expiry")).getText();
    }

    public String getUserLimit() {
        return this.driver.findElement(By.id((String)"license-users")).getText();
    }

    public boolean isUpdated() {
        return this.getAuiSuccessMessages().contains("Your license has been updated.");
    }

    public LicenseEditPage edit() {
        this.editButton.click();
        return (LicenseEditPage)this.pageBinder.bind(LicenseEditPage.class, new Object[0]);
    }

    public String getOverLimitError() {
        return this.getMessage(By.cssSelector((String)".aui-message-error.over-limit"));
    }

    public String getExpiredEvalError() {
        return this.getMessage(By.cssSelector((String)".aui-message-error.eval-expired"));
    }

    public String getEvalWarning() {
        return this.getMessage(By.cssSelector((String)".aui-message-warning.eval-notexpired"));
    }

    public String getMaintenanceExpiredError() {
        return this.getMessage(By.cssSelector((String)".aui-message-error.commercial-expired"));
    }

    private String getMessage(By selector) {
        try {
            WebElement element = this.driver.findElement(selector);
            return element.getText();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

