/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.activity;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.webdriver.bitbucket.element.Avatar;
import com.atlassian.webdriver.bitbucket.element.activity.DiffLineCommentActivity;
import com.atlassian.webdriver.bitbucket.element.activity.FileCommentActivity;
import com.atlassian.webdriver.bitbucket.element.activity.GeneralCommentActivity;
import com.atlassian.webdriver.bitbucket.element.activity.ReviewerActivityItem;
import com.atlassian.webdriver.bitbucket.element.activity.StateActivityItem;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.junit.Assert;
import org.openqa.selenium.By;

public abstract class ActivityItem {
    @Inject
    protected PageBinder pageBinder;
    protected final PageElement activityContainer;

    public ActivityItem(@Nonnull PageElement activityContainer) {
        this.activityContainer = (PageElement)Preconditions.checkNotNull((Object)activityContainer, (Object)"activityContainer");
    }

    @Nonnull
    public static Class<? extends ActivityItem> getType(PageElement element) {
        ImmutableMap classes = ImmutableMap.of((Object)"general-comment-activity", GeneralCommentActivity.class, (Object)"diff-comment-activity", DiffLineCommentActivity.class, (Object)"file-comment-activity", FileCommentActivity.class, (Object)"reviewers-updated-activity", ReviewerActivityItem.class);
        Set cssClasses = element.getCssClasses().stream().filter(((Map)classes)::containsKey).collect(Collectors.toSet());
        if (cssClasses.isEmpty()) {
            return StateActivityItem.getType(element);
        }
        Assert.assertEquals((long)1L, (long)cssClasses.size());
        return (Class)classes.get(Iterators.getOnlyElement(cssClasses.iterator()));
    }

    @Nonnull
    public Avatar getAvatar() {
        return (Avatar)((Object)this.activityContainer.findAll(By.className((String)"user-avatar"), Avatar.class).get(0));
    }

    public TimedCondition isPresent() {
        return this.activityContainer.timed().isPresent();
    }
}

