/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.openqa.selenium.By;

public class FileTree
extends LegacyElementPageObject {
    public static final String FILE_TREE_CONTAINER_CSS_CLASS = "file-tree-container";

    public FileTree(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.find(By.cssSelector((String)".file-tree > ul > li")).timed().isPresent());
    }

    public List<Node> getNodes() {
        List lis = this.findAll(By.cssSelector((String)"ul li"));
        ArrayList<Node> nodes = new ArrayList<Node>(lis.size());
        for (PageElement li : lis) {
            boolean isLeaf = li.hasClass("jstree-leaf");
            PageElement link = li.find(By.tagName((String)"a"));
            nodes.add(new Node(link.getAttribute("href").replaceAll(".*#", ""), link.getText().trim(), isLeaf, li));
        }
        return nodes;
    }

    public List<Node> getLeafNodes() {
        return this.getNodes().stream().filter(Node::isLeaf).collect(Collectors.toList());
    }

    public FileTree search(final String text) {
        ElementUtils.waitUntilUpdated(this.find(By.cssSelector((String)".file-tree-wrapper")), new Runnable(){

            @Override
            public void run() {
                FileTree.this.find(By.cssSelector((String)".search input")).type(new CharSequence[]{text}).type(new CharSequence[]{"\n"});
            }
        });
        return this;
    }

    public <T> Map<Node, T> visitEachFile(Function<Node, T> eachFile) {
        for (PageElement el : this.findAll(By.cssSelector((String)"ul li.jstree-closed a"))) {
            el.click();
        }
        HashMap map = Maps.newHashMap();
        for (Node node : this.getLeafNodes()) {
            node.click();
            map.put(node, eachFile.apply(node));
        }
        return map;
    }

    @Nullable
    public Node getSelectedNode() {
        return this.getNodes().stream().filter(Node::isSelected).findFirst().orElse(null);
    }

    public static class Node {
        private final String name;
        private final boolean isLeaf;
        private final String path;
        private final PageElement el;

        public Node(String path, String name, boolean leaf, PageElement element) {
            this.path = path;
            this.name = name;
            this.isLeaf = leaf;
            this.el = element;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public TimedCondition isCommented() {
            return this.el.find(By.cssSelector((String)"a > ins.aui-icon")).timed().hasClass("aui-iconfont-devtools-file-commented");
        }

        public void click() {
            this.el.find(By.tagName((String)"a")).click();
        }

        public boolean isConflicted() {
            return this.isLeaf && this.el.find(By.tagName((String)"a")).hasClass("conflict");
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public boolean isSelected() {
            return this.isLeaf && this.el.find(By.tagName((String)"a")).hasClass("jstree-clicked");
        }

        public boolean isViewed() {
            return this.isLeaf && this.el.hasClass("viewed");
        }
    }
}

