/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.component.Header;
import com.atlassian.pageobjects.component.WebSudoBanner;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.AppSwitcherDropdown;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.element.RecentReposDropdown;
import com.atlassian.webdriver.bitbucket.element.UserDropdown;
import com.atlassian.webdriver.bitbucket.page.BitbucketLoginPage;
import com.atlassian.webdriver.bitbucket.page.LogoutPage;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class BitbucketHeader
extends AbstractElementPageObject
implements Header {
    @Inject
    protected WebDriver driver;

    public BitbucketHeader(@Nonnull PageElement pageElement) {
        super(pageElement);
    }

    public UserDropdown getUserDropdown() {
        return ((GlobalSecondary)this.getGlobal().getSecondary()).getUserDropdown();
    }

    public LinkElement getHelpLink() {
        return ((GlobalSecondary)this.getGlobal().getSecondary()).getHelpLink();
    }

    public RecentReposDropdown getRecentReposDropdown() {
        return ((GlobalPrimary)this.getGlobal().getPrimary()).getRecentReposDropdown();
    }

    public AppSwitcherDropdown getAppSwitcher() {
        return (AppSwitcherDropdown)this.pageBinder.bind(AppSwitcherDropdown.class, new Object[]{this.find(By.className((String)"app-switcher-trigger"))});
    }

    public boolean isLoggedIn() {
        return !this.driver.getCurrentUrl().contains("/login") && this.getUserDropdown().isLoggedIn();
    }

    public BitbucketLoginPage login() {
        this.find(By.id((String)"login-link")).click();
        return (BitbucketLoginPage)this.pageBinder.bind(BitbucketLoginPage.class, new Object[]{false});
    }

    public <M extends Page> M logout(Class<M> nextPage) {
        this.getUserDropdown().clickTrigger().clickLogout();
        return (M)(LogoutPage.class.isAssignableFrom(nextPage) ? (Page)this.pageBinder.bind(nextPage, new Object[0]) : this.pageBinder.navigateToAndBind(nextPage, new Object[0]));
    }

    public WebSudoBanner getWebSudoBanner() {
        throw new UnsupportedOperationException();
    }

    private HeaderGlobal getGlobal() {
        return (HeaderGlobal)this.pageBinder.bind(HeaderGlobal.class, new Object[]{this.find(By.className((String)"aui-header"))});
    }

    public static abstract class HeaderSection<P extends AbstractElementPageObject, S extends AbstractElementPageObject>
    extends AbstractElementPageObject {
        private final Class<P> primaryClass;
        private final Class<S> secondaryClass;

        protected HeaderSection(@Nonnull PageElement container, @Nonnull Class<P> primaryClass, @Nonnull Class<S> secondaryClass) {
            super(container);
            this.primaryClass = (Class)Preconditions.checkNotNull(primaryClass, (Object)"primaryClass");
            this.secondaryClass = (Class)Preconditions.checkNotNull(secondaryClass, (Object)"secondaryClass");
        }

        public P getPrimary() {
            return (P)((AbstractElementPageObject)this.pageBinder.bind(this.primaryClass, new Object[]{this.find(By.className((String)"aui-header-primary"))}));
        }

        public S getSecondary() {
            return (S)((AbstractElementPageObject)this.pageBinder.bind(this.secondaryClass, new Object[]{this.find(By.className((String)"aui-header-secondary"))}));
        }
    }

    public static class GlobalSecondary
    extends AbstractElementPageObject {
        public GlobalSecondary(@Nonnull PageElement container) {
            super(container);
        }

        public UserDropdown getUserDropdown() {
            return (UserDropdown)((Object)this.pageBinder.bind(UserDropdown.class, new Object[]{this.find(By.className((String)"user-dropdown"))}));
        }

        public LinkElement getHelpLink() {
            return (LinkElement)((Object)this.pageBinder.bind(LinkElement.class, new Object[]{this.find(By.className((String)"help-link"))}));
        }
    }

    public static class GlobalPrimary
    extends AbstractElementPageObject {
        public GlobalPrimary(@Nonnull PageElement container) {
            super(container);
        }

        public RecentReposDropdown getRecentReposDropdown() {
            return (RecentReposDropdown)this.pageBinder.bind(RecentReposDropdown.class, new Object[0]);
        }
    }

    public static class HeaderGlobal
    extends HeaderSection<GlobalPrimary, GlobalSecondary> {
        public HeaderGlobal(@Nonnull PageElement container) {
            super(container, GlobalPrimary.class, GlobalSecondary.class);
        }
    }
}

