/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.hooks;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.hooks.RepositoryHookRow;
import com.atlassian.webdriver.bitbucket.page.admin.hooks.RepositoryHooksPage;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.openqa.selenium.By;

public class RepositoryHookDropdownRow
extends RepositoryHookRow {
    public RepositoryHookDropdownRow(@Nonnull PageElement row, @Nonnull RepositoryHooksPage parent) {
        super(row, parent);
    }

    @Override
    public RepositoryHookRow bind() {
        return (RepositoryHookRow)this.pageBinder.bind(RepositoryHookDropdownRow.class, new Object[]{this.container, this.parent});
    }

    @Override
    public TimedQuery<RepositoryHookRow.HookState> getState() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> RepositoryHookRow.HookState.valueOf(this.container.find(By.name((String)"inherit-toggle")).getValue()));
    }

    @Override
    protected void selectState(RepositoryHookRow.HookState hookState) {
        String selector = ".Select-option";
        switch (hookState) {
            case INHERITED_ENABLED: {
                selector = selector + ".inherited";
                break;
            }
            case INHERITED_DISABLED: {
                selector = selector + ".inherited";
                break;
            }
            case ENABLED: {
                selector = selector + ".enabled:not(.inherited)";
                break;
            }
            case DISABLED: {
                selector = selector + ".disabled:not(.inherited)";
            }
        }
        PageElement dropdown = this.container.find(By.className((String)"inherit-toggle")).click();
        Poller.waitUntil((TimedQuery)dropdown.timed().hasClass("is-open"), (Matcher)IsEqual.equalTo((Object)true));
        dropdown.find(By.cssSelector((String)selector)).select();
    }
}

