/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.DashboardPullRequestSection;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class DashboardRecentlyClosedPullRequestSection
extends AbstractElementPageObject {
    private PageElement expander;
    private PageElement table;

    public DashboardRecentlyClosedPullRequestSection(@Nonnull PageElement container) {
        super(container);
        this.table = container.find(By.tagName((String)"table"));
        this.expander = container.find(By.className((String)"table-expander"));
    }

    public DashboardRecentlyClosedPullRequestSection expand() {
        if (!this.expander.isPresent() || this.table.isVisible()) {
            return this;
        }
        ElementUtils.scrollIntoView(this.expander);
        this.expander.click();
        Poller.waitUntilTrue((TimedQuery)this.table.timed().isVisible());
        return this;
    }

    public List<DashboardPullRequestSection.PullRequestRow> getPullRequests() {
        if (!this.table.isPresent()) {
            return Collections.emptyList();
        }
        return this.table.findAll(By.cssSelector((String)"tbody tr")).stream().map(ElementUtils.bind(this.pageBinder, DashboardPullRequestSection.PullRequestRow.class, new Object[0])).collect(Collectors.toList());
    }
}

