/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repo;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.Avatar;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.element.GroupAvatar;
import com.atlassian.webdriver.bitbucket.element.PermissionDialog;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class BranchPermissionsPage
extends BaseRepositoryPage {
    @ElementBy(id="branch-permissions-table")
    protected PageElement permissionTable;
    private final String branch;

    public BranchPermissionsPage(String projectKey, String slug) {
        this(projectKey, slug, null);
    }

    public BranchPermissionsPage(String projectKey, String slug, String branch) {
        super(projectKey, slug);
        this.branch = branch;
    }

    public String getUrl() {
        String url = String.format("/plugins/servlet/branch-permissions/%s/%s", this.projectKey, this.slug);
        if (this.branch != null) {
            url = url + "?at=" + this.branch;
        }
        return url;
    }

    public BranchPermissionDialog getOpenDialog() {
        return (BranchPermissionDialog)((Object)this.pageBinder.bind(BranchPermissionDialog.class, new Object[]{this}));
    }

    public BranchPermissionDialog addBranchPermissions() {
        this.elementFinder.find(By.id((String)"add-permission-button")).click();
        BranchPermissionDialog dialog = (BranchPermissionDialog)((Object)this.pageBinder.bind(BranchPermissionDialog.class, new Object[]{this}));
        Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
        return dialog;
    }

    public List<Row> getRows() {
        if (!((Boolean)this.hasPermissions().now()).booleanValue()) {
            return Collections.emptyList();
        }
        return this.permissionTable.findAll(By.cssSelector((String)"tbody[data-branch-type]")).stream().map(ElementUtils.bind(this.pageBinder, Row.class, this)).collect(Collectors.toList());
    }

    @Nonnull
    public TimedCondition hasPermissions() {
        return this.permissionTable.timed().isPresent();
    }

    public static class PatternPermissionDialog
    extends PermissionDialog {
        public PatternPermissionDialog(BranchPermissionsPage parent) {
            super(parent);
        }

        @Override
        public BranchPermissionsPage bindParentPage() {
            return (BranchPermissionsPage)this.pageBinder.bind(BranchPermissionsPage.class, new Object[]{this.parent.projectKey, this.parent.slug});
        }

        public PatternPermissionDialog setGlob(String glob) {
            this.find(By.id((String)"branch-pattern-field")).clear().type(new CharSequence[]{glob});
            return this;
        }

        public BranchPermissionDialog switchToBranch() {
            this.changeBranchType("Branch name");
            return (BranchPermissionDialog)((Object)this.pageBinder.bind(BranchPermissionDialog.class, new Object[]{this.parent}));
        }
    }

    public static class BranchPermissionDialog
    extends PermissionDialog {
        @ElementBy(id="ref-selector-trigger")
        private PageElement branchTrigger;
        @ElementBy(id="ref-selector")
        private PageElement branchField;

        public BranchPermissionDialog(BranchPermissionsPage parent) {
            super(parent);
        }

        @Override
        public BranchPermissionsPage bindParentPage() {
            return (BranchPermissionsPage)this.pageBinder.bind(BranchPermissionsPage.class, new Object[]{this.parent.projectKey, this.parent.slug});
        }

        public SearchableSelector getBranchSelector() {
            return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.branchTrigger, By.id((String)"revision-reference-selector-1"), this.branchField});
        }

        public PatternPermissionDialog switchToPattern() {
            this.changeBranchType("Branch pattern");
            return (PatternPermissionDialog)((Object)this.pageBinder.bind(PatternPermissionDialog.class, new Object[]{this.parent}));
        }
    }

    public static class Row
    extends AbstractElementPageObject {
        @Inject
        private Timeouts timeouts;
        private final BranchPermissionsPage parent;

        public Row(@Nonnull PageElement element, BranchPermissionsPage parent) {
            super(element);
            this.parent = parent;
        }

        public String getName() {
            return this.find(By.className((String)"branch-name-text")).getText();
        }

        public List<Avatar> getUsers() {
            ArrayList<Avatar> users = new ArrayList<Avatar>();
            for (PageElement element : this.findAll(By.className((String)"cell-users-or-groups"))) {
                users.addAll(element.findAll(By.className((String)"user-avatar"), Avatar.class));
            }
            return users;
        }

        public List<GroupAvatar> getGroups() {
            ArrayList<GroupAvatar> groups = new ArrayList<GroupAvatar>();
            for (PageElement element : this.findAll(By.className((String)"cell-users-or-groups"))) {
                groups.addAll(element.findAll(By.className((String)"group-avatar"), GroupAvatar.class));
            }
            return groups;
        }

        public void delete() {
            int originalSize = this.parent.getRows().size();
            this.showActions();
            this.clickDeleteButton();
            this.clickConfirmDeleteButton();
            Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Integer>(){

                public Integer get() {
                    return parent.getRows().size();
                }
            }), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)originalSize)));
        }

        public <T extends PermissionDialog> T edit(Class<T> dialogClass) {
            this.showActions();
            this.find(By.className((String)"edit-button")).click();
            return (T)((Object)((PermissionDialog)((Object)this.pageBinder.bind(dialogClass, new Object[]{this.parent}))));
        }

        private void showActions() {
            this.container.javascript().execute("jQuery('.cell-actions a').css('display', 'block').css('visibility', 'visible');", new Object[0]);
            Poller.waitUntilTrue((TimedQuery)this.getActionsCell().find(By.tagName((String)"a")).timed().isVisible());
        }

        private PageElement getActionsCell() {
            return this.find(By.className((String)"cell-actions"));
        }

        private void clickDeleteButton() {
            this.find(By.className((String)"delete-button")).click();
        }

        private void clickConfirmDeleteButton() {
            Dialog2 deleteConfirmDialog = (Dialog2)((Object)this.pageBinder.bind(Dialog2.class, new Object[]{By.id((String)"branch-permission-delete-confirm-dialog")}));
            deleteConfirmDialog.clickMainAction();
        }
    }
}

