/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyPullRequestList;
import com.atlassian.webdriver.bitbucket.element.TabItem;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;

public class InboxDialog {
    private static final String REVIEWING_TAB = "Reviewing";
    private static final String CREATED_TAB = "Created";
    @Inject
    private PageBinder pageBinder;
    @Inject
    private PageElementFinder pageElementFinder;
    @ElementBy(id="inline-dialog-inbox-pull-requests-content")
    private PageElement inboxDialog;

    @WaitUntil
    public void waitTabIsLoaded() {
        Poller.waitUntilFalse((TimedQuery)this.inboxDialog.find(By.cssSelector((String)".active-pane .spinner")).timed().isVisible());
    }

    public LegacyPullRequestList getActivePullRequestList() {
        LegacyPullRequestList list = (LegacyPullRequestList)((Object)this.pageBinder.bind(LegacyPullRequestList.class, new Object[]{By.cssSelector((String)"#inline-dialog-inbox-pull-requests-content .active-pane .pull-requests-table"), TimeoutType.DEFAULT}));
        Poller.waitUntilFalse((TimedQuery)this.inboxDialog.find(By.cssSelector((String)".active-pane .spinner")).timed().isVisible());
        return list;
    }

    public boolean isShowingReviewing() {
        return this.getActivePullRequestListName().equals(REVIEWING_TAB);
    }

    public boolean isShowingCreated() {
        return this.getActivePullRequestListName().equals(CREATED_TAB);
    }

    public void switchToReviewing() {
        this.getTab(REVIEWING_TAB).click();
        this.waitTabIsLoaded();
    }

    public void switchToCreated() {
        this.getTab(CREATED_TAB).click();
        this.waitTabIsLoaded();
    }

    public boolean isActivePullRequestListEmpty() {
        this.getActivePullRequestList();
        return this.inboxDialog.find(By.cssSelector((String)".active-pane .aui-iconfont-workbox-empty")).isPresent();
    }

    public void close() {
        if (this.isOpen()) {
            this.pageElementFinder.find(By.tagName((String)"body")).type(new CharSequence[]{Keys.ESCAPE});
        }
    }

    public boolean isOpen() {
        return this.inboxDialog.isVisible();
    }

    private String getActivePullRequestListName() {
        return this.inboxDialog.find(By.className((String)"active-tab")).getText();
    }

    private Collection<TabItem> getTabItems() {
        if (this.isOpen()) {
            return this.inboxDialog.findAll(By.cssSelector((String)".aui-tabs > .tabs-menu > li"), TabItem.class);
        }
        return Collections.emptyList();
    }

    private TabItem getTab(String text) {
        for (TabItem tab : this.getTabItems()) {
            if (!tab.getText().trim().equalsIgnoreCase(text.trim())) continue;
            return tab;
        }
        throw new NoSuchElementException(text + " tab not found");
    }
}

