/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.tasks;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.tasks.Task;
import com.atlassian.webdriver.bitbucket.element.tasks.TaskState;
import java.util.List;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class TaskTable
extends LegacyElementPageObject {
    public static final String SELECTOR = "#task-list-dialog .task-list";

    public TaskTable(@Nonnull PageElement element) {
        super(element);
    }

    public TaskTable() {
        super(By.cssSelector((String)SELECTOR));
    }

    public TaskTable(By locator, WebDriverLocatable parent) {
        super(locator, parent);
    }

    @WaitUntil
    private void isLoaded() {
        Poller.waitUntilFalse((TimedQuery)this.find(By.className((String)"spinner")).timed().isPresent());
        Poller.waitUntilTrue((TimedQuery)this.find(By.className((String)"task-container")).timed().isVisible());
    }

    public Row getRowByCommentId(long commentId) {
        for (Row row : this.getRows()) {
            if (row.getCommentId() != commentId) continue;
            return row;
        }
        return null;
    }

    public int size() {
        return this.getRows().size();
    }

    private List<Row> getRows() {
        return this.findAll(By.className((String)"task-container"), Row.class);
    }

    public Row getRowAt(int position) {
        List<Row> rows = this.getRows();
        return rows.size() > position ? rows.get(position) : null;
    }

    public static class Row
    extends LegacyElementPageObject {
        public static final String CLASS = "task-container";

        public Row(@Nonnull PageElement container) {
            super(container);
        }

        public Row(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public long getCommentId() {
            return Long.parseLong(this.getTask().getAttribute("data-comment-id"));
        }

        public TaskState getState() {
            return this.getTask().getState();
        }

        public String getText() {
            return this.find(By.className((String)"message")).getText();
        }

        public String getFileName() {
            if (!this.isExpanded()) {
                this.expand();
            }
            return this.getCommentDiffAnchor().getText();
        }

        public String getFilePath() {
            return this.getCommentDiffAnchor().find(By.className((String)"aui-button")).getAttribute("data-path");
        }

        public PageElement getCheckbox() {
            return this.find(By.className((String)"task-checkbox"));
        }

        public PageElement getRemoveButton() {
            PageElement button = this.find(By.className((String)"task-list-dialog-remove-button"));
            button.javascript().execute("jQuery(arguments[0]).show()", new Object[0]);
            return button;
        }

        public Row resolveTask() {
            if (!this.getState().equals((Object)TaskState.OPEN)) {
                throw new IllegalStateException("Expected task to be in open state to resolve");
            }
            return this.clickAndExpectState(TaskState.RESOLVED);
        }

        public Row reopenTask() {
            if (!this.getState().equals((Object)TaskState.RESOLVED)) {
                throw new IllegalStateException("Expected task to be in resolved state to reopen");
            }
            return this.clickAndExpectState(TaskState.OPEN);
        }

        public Row expand() {
            if (!this.isCollapsed()) {
                throw new IllegalStateException("Task row is already expanded or expanding");
            }
            this.find(By.className((String)"task-content")).click();
            Poller.waitUntilTrue((TimedQuery)this.timed().hasClass("expanded"));
            return this;
        }

        public Row collapse() {
            if (!this.isExpanded()) {
                throw new IllegalStateException("Task row is already collapsed or collapsing");
            }
            this.find(By.className((String)"task-content")).click();
            Poller.waitUntilTrue((TimedQuery)this.timed().hasClass("collapsed"));
            return this;
        }

        public void deleteTask() {
            this.expand().getTask().delete();
        }

        public Task editTask() throws Exception {
            return this.expand().getTask().edit();
        }

        protected Task getTask() {
            return (Task)this.find(By.className((String)"task"), Task.class);
        }

        private Row clickAndExpectState(TaskState expectedState) {
            this.getCheckbox().click();
            Poller.waitUntil((TimedQuery)this.getTask().timed().getAttribute("data-task-state"), (Matcher)Matchers.equalToIgnoringCase((String)expectedState.name()));
            return this;
        }

        private PageElement getCommentDiffAnchor() {
            return this.find(By.className((String)"comment-diff-anchor"));
        }

        private boolean isCollapsed() {
            return this.hasClass("collapsed");
        }

        private boolean isExpanded() {
            return this.hasClass("expanded");
        }
    }
}

