/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.tasks;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.tasks.TaskState;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class Task
extends LegacyElementPageObject {
    public Task(@Nonnull PageElement element) {
        super(element);
    }

    public Task(By locator, WebDriverLocatable parent) {
        super(locator, parent);
    }

    public Task(By locator) {
        super(locator);
    }

    public Task(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public Task(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    @WaitUntil
    public void waitUntilVisible() {
        Poller.waitUntilTrue((TimedQuery)this.timed().isVisible());
    }

    public Task setTaskText(String text) {
        PageElement textField = this.getTextField();
        Poller.waitUntilTrue((TimedQuery)textField.timed().isVisible());
        ElementUtils.selectContent(textField).type(new CharSequence[]{text});
        return this;
    }

    public String getTaskText() {
        return this.find(By.className((String)"task-content")).getText();
    }

    public PageElement getCheckbox() {
        return this.find(By.className((String)"task-checkbox"));
    }

    public void save() {
        this.find(By.className((String)"task-save")).click();
        this.waitUntilNotPendingSync();
    }

    public Task edit() {
        this.find(By.className((String)"task-edit")).click();
        Poller.waitUntilTrue((TimedQuery)this.getTextField().timed().isVisible());
        return this;
    }

    public TaskState getState() {
        return TaskState.fromString(this.getAttribute("data-task-state"));
    }

    public long getTaskId() {
        Poller.waitUntil((TimedQuery)this.timed().getAttribute("data-task-id"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"undefined")));
        return Long.parseLong(this.getAttribute("data-task-id"));
    }

    public void resolve() {
        this.transitionState(TaskState.OPEN, TaskState.RESOLVED);
    }

    public void reopen() {
        this.transitionState(TaskState.RESOLVED, TaskState.OPEN);
    }

    public void delete() {
        this.find(By.className((String)"task-delete")).click();
        Poller.waitUntilFalse((TimedQuery)this.timed().isPresent());
    }

    private PageElement getTextField() {
        return this.find(By.tagName((String)"textarea"));
    }

    private void transitionState(TaskState initialState, TaskState finalState) {
        if (this.getState() != initialState) {
            throw new IllegalStateException(String.format("Expected task to be %s to transition to %s, but it was %s", new Object[]{initialState, finalState, this.getState()}));
        }
        this.getCheckbox().click();
        Poller.waitUntil((TimedQuery)this.timed().getAttribute("data-task-state"), (Matcher)Matchers.equalTo((Object)finalState.toString()));
        this.waitUntilNotPendingSync();
    }

    private void waitUntilNotPendingSync() {
        Poller.waitUntil((TimedQuery)this.timed().getAttribute("class"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"task-pending-sync")));
    }
}

