/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.activity;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.activity.ActivityItem;
import com.atlassian.webdriver.bitbucket.element.activity.MergeActivityItem;
import com.atlassian.webdriver.bitbucket.util.DateUtils;
import java.util.Date;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class StateActivityItem
extends ActivityItem {
    public StateActivityItem(PageElement activityContainer) {
        super(activityContainer);
    }

    @Nonnull
    public static Class<? extends ActivityItem> getType(PageElement element) {
        return StateActivityItem.getActivityType(element).type;
    }

    public String getState() {
        return StateActivityItem.getActivityState(this.activityContainer);
    }

    public ActivityType getType() {
        return StateActivityItem.getActivityType(this.activityContainer);
    }

    public String getTimePretty() {
        return this.getActionTime().getText();
    }

    public Date getTime() {
        return DateUtils.parse(DateUtils.getDateTimeFormat(), this.getActionTime().getAttribute("datetime"));
    }

    @Nonnull
    public static ActivityType getActivityType(PageElement element) {
        for (ActivityType activityType : ActivityType.values()) {
            if (!activityType.matches(element)) continue;
            return activityType;
        }
        throw new AssertionError((Object)"Should not happen");
    }

    private PageElement getActionElement() {
        return this.activityContainer.find(By.className((String)"action"));
    }

    private PageElement getActionTime() {
        return this.getActionElement().find(By.tagName((String)"time"));
    }

    private static String getActivityState(PageElement element) {
        return element.find(By.className((String)"pull-request-state-lozenge")).getText();
    }

    public static enum ActivityType {
        MERGED(MergeActivityItem.class){

            @Override
            public boolean matches(PageElement activityElement) {
                return "merged".equalsIgnoreCase(StateActivityItem.getActivityState(activityElement));
            }
        }
        ,
        GENERAL(StateActivityItem.class);

        private final Class<? extends StateActivityItem> type;

        private ActivityType(Class<? extends StateActivityItem> type) {
            this.type = type;
        }

        public boolean matches(PageElement activityElement) {
            return true;
        }
    }
}

